/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp;

public enum JDWPValueTag {
    ARRAY('[', false, true, null),
    BYTE('B', true, false, (byte)0),
    CHARACTER('C', true, false, Character.valueOf('\u0000')),
    OBJECT('L', false, true, null),
    FLOAT('F', true, false, Float.valueOf(0.0f)),
    DOUBLE('D', true, false, 0.0),
    INTEGER('I', true, false, 0),
    LONG('J', true, false, 0L),
    SHORT('S', true, false, (short)0),
    VOID('V', false, false, null),
    BOOLEAN('Z', true, false, false),
    STRING('s', false, true, null),
    THREAD('t', false, true, null),
    THREAD_GROUP('g', false, true, null),
    CLASS_LOADER('l', false, true, null),
    CLASS_OBJECT('c', false, true, null);

    public final char tag;
    public final boolean isNumber;
    public final boolean isObject;
    public final Object defaultValue;

    private JDWPValueTag(char __tag, boolean __isNumber, boolean __isObject, Object __defaultValue) {
        this.tag = __tag;
        this.isNumber = __isNumber;
        this.isObject = __isObject;
        this.defaultValue = __defaultValue;
    }

    public static JDWPValueTag fromTag(int __tag) {
        switch (__tag) {
            case 91: {
                return ARRAY;
            }
            case 90: {
                return BOOLEAN;
            }
            case 66: {
                return BYTE;
            }
            case 83: {
                return SHORT;
            }
            case 67: {
                return CHARACTER;
            }
            case 73: {
                return INTEGER;
            }
            case 70: {
                return FLOAT;
            }
            case 74: {
                return LONG;
            }
            case 68: {
                return DOUBLE;
            }
            case 76: {
                return OBJECT;
            }
            case 86: {
                return VOID;
            }
            case 115: {
                return STRING;
            }
            case 116: {
                return THREAD;
            }
            case 103: {
                return THREAD_GROUP;
            }
            case 108: {
                return CLASS_LOADER;
            }
            case 99: {
                return CLASS_OBJECT;
            }
        }
        return null;
    }

    public static JDWPValueTag fromSignature(String __signature) throws NullPointerException {
        if (__signature == null) {
            throw new NullPointerException("NARG");
        }
        char first = !__signature.isEmpty() ? __signature.charAt(0) : (char)'\u0000';
        switch (first) {
            case '[': {
                return ARRAY;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'C': {
                return CHARACTER;
            }
            case 'I': {
                return INTEGER;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                return VOID;
            }
            case 's': {
                return STRING;
            }
            case 't': {
                return THREAD;
            }
            case 'g': {
                return THREAD_GROUP;
            }
            case 'l': {
                return CLASS_LOADER;
            }
            case 'c': {
                return CLASS_OBJECT;
            }
        }
        switch (__signature) {
            case "Ljava/lang/String;": {
                return STRING;
            }
            case "Ljava/lang/Thread;": 
            case "Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;": {
                return THREAD;
            }
            case "Ljava/lang/Class;": {
                return CLASS_OBJECT;
            }
        }
        return OBJECT;
    }
}

