/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetArrayReference;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPValueTag;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostValue;
import cc.squirreljme.jdwp.host.views.JDWPViewObject;
import cc.squirreljme.jdwp.host.views.JDWPViewType;

public enum JDWPHostCommandSetArrayReference implements JDWPCommandHandler
{
    LENGTH(JDWPCommandSetArrayReference.LENGTH){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object array = __controller.readArray(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(__controller.viewObject().arrayLength(array));
            return rv;
        }
    }
    ,
    GET_VALUES(JDWPCommandSetArrayReference.GET_VALUES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object array = __controller.readArray(__packet, false);
            JDWPViewType viewType = __controller.viewType();
            Object componentType = viewType.componentType(__controller.viewObject().type(array));
            int off = __packet.readInt();
            int len = __packet.readInt();
            JDWPViewObject viewObject = __controller.viewObject();
            int arrayLength = viewObject.arrayLength(array);
            if (off < 0 || len < 0 || off + len > arrayLength) {
                throw JDWPErrorType.INVALID_LENGTH.toss(array, off + len);
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            JDWPValueTag tag = JDWPValueTag.fromSignature(viewType.signature(componentType));
            rv.writeByte(tag.tag);
            rv.writeInt(len);
            for (int i2 = 0; i2 < len; ++i2) {
                try (JDWPHostValue value = __controller.value();){
                    if (!viewObject.readArray(array, off + i2, value)) {
                        value.set(tag.defaultValue);
                    }
                    __controller.writeValue(rv, value, tag, true);
                    if (value.get() == null || !tag.isObject) continue;
                    __controller.getState().items.put(value.get());
                    continue;
                }
            }
            return rv;
        }
    };

    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetArrayReference(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }
}

