/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetClassObjectReference;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.views.JDWPViewObject;
import cc.squirreljme.jdwp.host.views.JDWPViewType;

public enum JDWPHostCommandSetClassObjectReference implements JDWPCommandHandler
{
    REFLECTED_TYPE(JDWPCommandSetClassObjectReference.REFLECTED_TYPE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object objectType;
            Object object = __controller.readObject(__packet, false);
            JDWPViewType viewType = __controller.viewType();
            JDWPViewObject viewObject = __controller.viewObject();
            if (!(viewObject != null && viewObject.isValid(viewObject) || (objectType = __controller.viewObject().type(object)) != null && viewType.isValid(objectType) && "Ljava/lang/Class;".equals(viewType.signature(objectType)))) {
                throw JDWPErrorType.INVALID_OBJECT.toss(object, System.identityHashCode(object), new Throwable("Not a Class object."));
            }
            Object found = viewType.typeOfClassInstance(object);
            if (found != null && viewType.isValid(found)) {
                __controller.getState().items.put(found);
            }
            if (found == null || !viewType.isValid(found)) {
                for (Object type : __controller.allTypes(false)) {
                    Object maybe = viewType.instance(type);
                    if (maybe != object) continue;
                    found = type;
                    break;
                }
            }
            if (found == null || !viewType.isValid(found)) {
                throw JDWPErrorType.INVALID_OBJECT.toss(object, System.identityHashCode(object), new Throwable("No matching type found."));
            }
            __controller.getState().items.put(found);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            __controller.writeTaggedId(rv, found);
            return rv;
        }
    };

    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetClassObjectReference(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }
}

