/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPClassPatternMatcher;
import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetEventRequest;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPEventKind;
import cc.squirreljme.jdwp.JDWPEventModifierKind;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPStepDepth;
import cc.squirreljme.jdwp.JDWPStepSize;
import cc.squirreljme.jdwp.JDWPSuspendPolicy;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostEventRequest;
import cc.squirreljme.jdwp.host.JDWPHostLocation;
import cc.squirreljme.jdwp.host.event.JDWPHostCallStackStepping;
import cc.squirreljme.jdwp.host.event.JDWPHostEventFilter;
import cc.squirreljme.jdwp.host.event.JDWPHostExceptionOnly;
import cc.squirreljme.jdwp.host.event.JDWPHostFieldOnly;

public enum JDWPHostCommandSetEventRequest implements JDWPCommandHandler
{
    SET(JDWPCommandSetEventRequest.SET){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPEventKind eventKind = JDWPEventKind.of(__packet.readByte());
            if (eventKind == null) {
                return __controller.reply(__packet.id(), JDWPErrorType.INVALID_EVENT_TYPE);
            }
            JDWPSuspendPolicy suspendPolicy = JDWPSuspendPolicy.of(__packet.readByte());
            boolean hasFilter = false;
            int occurrenceLimit = -1;
            Object thread = null;
            Object type = null;
            JDWPClassPatternMatcher includeClass = null;
            JDWPClassPatternMatcher excludeClass = null;
            JDWPHostFieldOnly fieldOnly = null;
            JDWPHostLocation location = null;
            Object thisInstance = null;
            boolean thisInstanceSet = false;
            JDWPHostExceptionOnly exception = null;
            JDWPHostCallStackStepping callStackStepping = null;
            int numModifiers = __packet.readInt();
            block12: for (int i2 = 0; i2 < numModifiers; ++i2) {
                JDWPEventModifierKind modKind = JDWPEventModifierKind.of(__packet.readByte());
                if (modKind == null) {
                    return __controller.reply(__packet.id(), JDWPErrorType.NOT_IMPLEMENTED);
                }
                if (!eventKind.isValidModifier(modKind)) {
                    throw JDWPErrorType.ILLEGAL_ARGUMENT.toss(null, modKind.ordinal(), null);
                }
                if (modKind != JDWPEventModifierKind.LIMIT_OCCURRENCES) {
                    hasFilter = true;
                }
                switch (modKind) {
                    case LIMIT_OCCURRENCES: {
                        occurrenceLimit = __packet.readInt();
                        continue block12;
                    }
                    case THREAD_ONLY: {
                        thread = __controller.readThread(__packet);
                        if (thread == null) continue block12;
                        __controller.getState().items.put(thread);
                        continue block12;
                    }
                    case CLASS_ONLY: {
                        type = __controller.readType(__packet, false);
                        if (type == null) continue block12;
                        __controller.getState().items.put(type);
                        continue block12;
                    }
                    case CLASS_MATCH_PATTERN: {
                        includeClass = new JDWPClassPatternMatcher(__packet.readString());
                        continue block12;
                    }
                    case CLASS_EXCLUDE_PATTERN: {
                        excludeClass = new JDWPClassPatternMatcher(__packet.readString());
                        continue block12;
                    }
                    case LOCATION_ONLY: {
                        location = __controller.readLocation(__packet);
                        continue block12;
                    }
                    case EXCEPTION_ONLY: {
                        exception = new JDWPHostExceptionOnly(__controller.readType(__packet, true), __packet.readBoolean(), __packet.readBoolean());
                        continue block12;
                    }
                    case FIELD_ONLY: {
                        Object atType = __controller.readType(__packet, false);
                        int fieldDx = __packet.readId();
                        if (!__controller.viewType().isValidField(atType, fieldDx)) {
                            JDWPErrorType.INVALID_FIELD_ID.toss(atType, fieldDx, null);
                        }
                        fieldOnly = new JDWPHostFieldOnly(atType, fieldDx);
                        continue block12;
                    }
                    case CALL_STACK_STEPPING: {
                        callStackStepping = new JDWPHostCallStackStepping(__controller.readThread(__packet), JDWPStepSize.of(__packet.readInt()), JDWPStepDepth.of(__packet.readInt()));
                        continue block12;
                    }
                    case THIS_INSTANCE_ONLY: {
                        thisInstance = __controller.readObject(__packet, true);
                        thisInstanceSet = true;
                        continue block12;
                    }
                    default: {
                        return __controller.reply(__packet.id(), JDWPErrorType.NOT_IMPLEMENTED);
                    }
                }
            }
            JDWPHostEventFilter eventFilter = hasFilter ? new JDWPHostEventFilter(thread, type, includeClass, excludeClass, fieldOnly, location, thisInstanceSet, thisInstance, exception, callStackStepping) : null;
            JDWPHostEventRequest request = new JDWPHostEventRequest(__controller.getCommLink().nextId(), eventKind, suspendPolicy, occurrenceLimit, eventFilter);
            __controller.getEventManager().addEventRequest(request);
            __controller.tripRequest(request);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(request.id);
            return rv;
        }
    }
    ,
    CLEAR(JDWPCommandSetEventRequest.CLEAR){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPEventKind eventKind = JDWPEventKind.of(__packet.readByte());
            if (eventKind == null) {
                return __controller.reply(__packet.id(), JDWPErrorType.INVALID_EVENT_TYPE);
            }
            __controller.getEventManager().delete(__packet.readInt());
            return null;
        }
    }
    ,
    CLEAR_ALL_BREAKPOINTS(JDWPCommandSetEventRequest.CLEAR_ALL_BREAKPOINTS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            __controller.getEventManager().clear(JDWPEventKind.BREAKPOINT);
            return null;
        }
    };

    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetEventRequest(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }
}

