/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetMethod;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPLocalVariable;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.views.JDWPViewType;
import net.multiphasicapps.classfile.MethodDescriptor;

public enum JDWPHostCommandSetMethod implements JDWPCommandHandler
{
    LINE_TABLE(JDWPCommandSetMethod.LINE_TABLE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object classy = __controller.readType(__packet, false);
            int methodId = __packet.readId();
            JDWPViewType viewType = __controller.viewType();
            if (!viewType.isValidMethod(classy, methodId)) {
                throw JDWPErrorType.INVALID_METHOD_ID.toss(classy, methodId);
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            long addrCount = viewType.methodLocationCount(classy, methodId);
            rv.writeLong(0L);
            rv.writeLong(Math.max(-1L, addrCount));
            int[] lineTable = viewType.methodLineTable(classy, methodId);
            if (addrCount <= 0L || lineTable == null || lineTable.length == 0 || lineTable[0] < 0) {
                rv.writeInt(0);
            } else {
                int i2;
                int countedLines = 0;
                int[] paddedPCs = new int[lineTable.length];
                int[] paddedLines = new int[lineTable.length];
                int n2 = lineTable.length;
                int lastLine = -1;
                for (i2 = 0; i2 < n2; ++i2) {
                    int at2 = lineTable[i2];
                    if (i2 != 0 && at2 == lastLine) continue;
                    paddedPCs[countedLines] = i2;
                    paddedLines[countedLines++] = at2;
                    lastLine = at2;
                }
                rv.writeInt(countedLines);
                n2 = countedLines;
                for (i2 = 0; i2 < n2; ++i2) {
                    rv.writeLong(paddedPCs[i2]);
                    rv.writeInt(Math.max(0, paddedLines[i2]));
                }
            }
            return rv;
        }
    }
    ,
    VARIABLE_TABLE(JDWPCommandSetMethod.VARIABLE_TABLE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__variables(false, __controller, __packet);
        }
    }
    ,
    BYTE_CODES(JDWPCommandSetMethod.BYTE_CODES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object classy = __controller.readType(__packet, false);
            int methodId = __packet.readId();
            JDWPViewType viewType = __controller.viewType();
            if (!viewType.isValidMethod(classy, methodId)) {
                throw JDWPErrorType.INVALID_METHOD_ID.toss(classy, methodId);
            }
            byte[] byteCode = viewType.methodByteCode(classy, methodId);
            if (byteCode == null) {
                throw JDWPErrorType.ABSENT_INFORMATION.toss(classy, methodId);
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(byteCode.length);
            rv.write(byteCode, 0, byteCode.length);
            return rv;
        }
    }
    ,
    VARIABLE_TABLE_WITH_GENERIC(JDWPCommandSetMethod.VARIABLE_TABLE_WITH_GENERIC){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__variables(true, __controller, __packet);
        }
    };

    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetMethod(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }

    JDWPPacket __variables(boolean __generic, JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
        Object classy = __controller.readType(__packet, false);
        int methodId = __packet.readId();
        JDWPViewType viewType = __controller.viewType();
        if (!viewType.isValidMethod(classy, methodId)) {
            throw JDWPErrorType.INVALID_METHOD_ID.toss(classy, methodId);
        }
        JDWPLocalVariable[] variables = viewType.methodVariableTable(classy, methodId);
        if (variables == null || variables.length <= 0) {
            return __controller.reply(__packet.id(), JDWPErrorType.ABSENT_INFORMATION);
        }
        JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
        MethodDescriptor desc = new MethodDescriptor(viewType.methodSignature(classy, methodId));
        rv.writeInt(desc.argumentSlotCount());
        int count = variables.length;
        rv.writeInt(count);
        for (int i2 = 0; i2 < count; ++i2) {
            JDWPLocalVariable variable = variables[i2];
            rv.writeLong(variable.startPc);
            rv.writeString(variable.variableName);
            rv.writeString(variable.fieldDescriptor);
            if (__generic) {
                rv.writeString("");
            }
            rv.writeInt(variable.length);
            rv.writeInt(variable.localSlot);
        }
        return rv;
    }
}

