/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetObjectReference;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPValueTag;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostValue;
import cc.squirreljme.jdwp.host.views.JDWPViewObject;
import cc.squirreljme.jdwp.host.views.JDWPViewType;

public enum JDWPHostCommandSetObjectReference implements JDWPCommandHandler
{
    REFERENCE_TYPE(JDWPCommandSetObjectReference.REFERENCE_TYPE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object object = __controller.readObject(__packet, false);
            Object type = __controller.viewType().isValid(object) ? object : __controller.viewObject().type(object);
            __controller.getState().items.put(object);
            if (type != null) {
                __controller.getState().items.put(type);
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            __controller.writeTaggedId(rv, type);
            return rv;
        }
    }
    ,
    GET_VALUES(JDWPCommandSetObjectReference.GET_VALUES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewObject viewObject = __controller.viewObject();
            JDWPViewType viewType = __controller.viewType();
            Object object = __controller.readObject(__packet, false);
            Object type = viewObject.type(object);
            int numFields = __packet.readInt();
            int[] fields = new int[numFields];
            for (int i2 = 0; i2 < numFields; ++i2) {
                int fieldDx = __packet.readId();
                if (!viewType.isValidField(type, fieldDx)) {
                    throw JDWPErrorType.INVALID_FIELD_ID.toss(type, fieldDx);
                }
                fields[i2] = fieldDx;
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(numFields);
            for (int i3 = 0; i3 < numFields; ++i3) {
                try (JDWPHostValue value = __controller.value();){
                    String fieldSig = viewType.fieldSignature(type, fields[i3]);
                    JDWPValueTag tag = JDWPValueTag.fromSignature(fieldSig);
                    if (!viewObject.readValue(object, fields[i3], value)) {
                        value.set(tag.defaultValue);
                    }
                    __controller.writeValue(rv, value, tag, false);
                    if (value.get() == null || !tag.isObject) continue;
                    __controller.getState().items.put(value.get());
                    continue;
                }
            }
            return rv;
        }
    }
    ,
    IS_COLLECTED(JDWPCommandSetObjectReference.IS_COLLECTED){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            __controller.readObject(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeBoolean(false);
            return rv;
        }
    };

    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetObjectReference(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }
}

