/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetReferenceType;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPValueTag;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostValue;
import cc.squirreljme.jdwp.host.views.JDWPViewType;

public enum JDWPHostCommandSetReferenceType implements JDWPCommandHandler
{
    SIGNATURE(JDWPCommandSetReferenceType.SIGNATURE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__signature(false, __controller, __packet);
        }
    }
    ,
    CLASS_LOADER(JDWPCommandSetReferenceType.CLASS_LOADER){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object type = __controller.readType(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            Object loader = __controller.viewType().classLoader(type);
            if (loader != null) {
                __controller.getState().items.put(loader);
            }
            rv.writeId(System.identityHashCode(loader));
            return rv;
        }
    }
    ,
    MODIFIERS(JDWPCommandSetReferenceType.MODIFIERS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object type = __controller.readType(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(__controller.viewType().flags(type));
            return rv;
        }
    }
    ,
    FIELDS(JDWPCommandSetReferenceType.FIELDS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__fields(false, __controller, __packet);
        }
    }
    ,
    METHODS(JDWPCommandSetReferenceType.METHODS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__methods(false, __controller, __packet);
        }
    }
    ,
    STATIC_FIELD_VALUE(JDWPCommandSetReferenceType.STATIC_FIELD_VALUE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewType viewType = __controller.viewType();
            Object type = __controller.readType(__packet, false);
            int numFields = __packet.readInt();
            int[] fields = new int[numFields];
            for (int i2 = 0; i2 < numFields; ++i2) {
                int fieldDx = __packet.readId();
                if (!viewType.isValidField(type, fieldDx)) {
                    throw JDWPErrorType.INVALID_FIELD_ID.toss(type, fieldDx);
                }
                fields[i2] = fieldDx;
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(numFields);
            for (int i3 = 0; i3 < numFields; ++i3) {
                try (JDWPHostValue value = __controller.value();){
                    String fieldSig = viewType.fieldSignature(type, fields[i3]);
                    JDWPValueTag tag = JDWPValueTag.fromSignature(fieldSig);
                    if (!viewType.readValue(type, fields[i3], value)) {
                        value.set(tag.defaultValue);
                    }
                    __controller.writeValue(rv, value, tag, false);
                    if (value.get() == null || !tag.isObject) continue;
                    __controller.getState().items.put(value.get());
                    continue;
                }
            }
            return rv;
        }
    }
    ,
    SOURCE_FILE(JDWPCommandSetReferenceType.SOURCE_FILE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object type = __controller.readType(__packet, false);
            String sourceFile = __controller.viewType().sourceFile(type);
            if (sourceFile == null) {
                throw JDWPErrorType.ABSENT_INFORMATION.toss(type, System.identityHashCode(type));
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeString(sourceFile);
            return rv;
        }
    }
    ,
    INTERFACES(JDWPCommandSetReferenceType.INTERFACES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object type = __controller.readType(__packet, false);
            Object[] interfaces = __controller.viewType().interfaceTypes(type);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(interfaces.length);
            for (Object impl : interfaces) {
                __controller.writeObject(rv, impl);
                __controller.getState().items.put(impl);
            }
            return rv;
        }
    }
    ,
    CLASS_OBJECT(JDWPCommandSetReferenceType.CLASS_OBJECT){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object type = __controller.readType(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            Object instance = __controller.viewType().instance(type);
            __controller.getState().items.put(instance);
            __controller.writeObject(rv, instance);
            return rv;
        }
    }
    ,
    SIGNATURE_WITH_GENERIC(JDWPCommandSetReferenceType.SIGNATURE_WITH_GENERIC){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__signature(true, __controller, __packet);
        }
    }
    ,
    FIELDS_WITH_GENERIC(JDWPCommandSetReferenceType.FIELDS_WITH_GENERIC){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__fields(true, __controller, __packet);
        }
    }
    ,
    METHODS_WITH_GENERIC(JDWPCommandSetReferenceType.METHODS_WITH_GENERIC){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__methods(true, __controller, __packet);
        }
    }
    ,
    CLASS_FILE_VERSION(JDWPCommandSetReferenceType.CLASS_FILE_VERSION){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object type = __controller.readType(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(51);
            rv.writeInt(0);
            return rv;
        }
    }
    ,
    CONSTANT_POOL(JDWPCommandSetReferenceType.CONSTANT_POOL){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object type = __controller.readType(__packet, false);
            int count = __controller.viewType().constantPoolCount(type);
            byte[] raw = __controller.viewType().constantPoolRaw(type);
            if (count < 0 || raw == null) {
                return __controller.reply(__packet.id(), JDWPErrorType.ABSENT_INFORMATION);
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(count);
            rv.writeInt(raw.length);
            rv.write(raw, 0, raw.length);
            return rv;
        }
    };

    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetReferenceType(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }

    JDWPPacket __fields(boolean __generic, JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
        JDWPViewType viewType = __controller.viewType();
        Object type = __controller.readType(__packet, false);
        JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
        if ("Ljava/lang/Class;".equals(viewType.signature(type))) {
            rv.writeInt(0);
            return rv;
        }
        int[] fields = viewType.fields(type);
        rv.writeInt(fields.length);
        for (int fieldDx : fields) {
            rv.writeId(fieldDx);
            rv.writeString(viewType.fieldName(type, fieldDx));
            rv.writeString(viewType.fieldSignature(type, fieldDx));
            if (__generic) {
                rv.writeString("");
            }
            rv.writeInt(viewType.fieldFlags(type, fieldDx));
        }
        return rv;
    }

    JDWPPacket __methods(boolean __generic, JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
        JDWPViewType viewType = __controller.viewType();
        Object type = __controller.readType(__packet, false);
        JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
        int[] methods = viewType.methods(type);
        rv.writeInt(methods.length);
        for (int methodDx : methods) {
            rv.writeId(methodDx);
            rv.writeString(viewType.methodName(type, methodDx));
            rv.writeString(viewType.methodSignature(type, methodDx));
            if (__generic) {
                rv.writeString("");
            }
            rv.writeInt(viewType.methodFlags(type, methodDx));
        }
        return rv;
    }

    JDWPPacket __signature(boolean __generic, JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
        Object type = __controller.readType(__packet, false);
        JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
        rv.writeString(__controller.viewType().signature(type));
        if (__generic) {
            rv.writeString("");
        }
        return rv;
    }
}

