/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandException;
import cc.squirreljme.jdwp.JDWPCommandSetStackFrame;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPValueTag;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostValue;
import cc.squirreljme.jdwp.host.views.JDWPViewFrame;
import cc.squirreljme.jdwp.host.views.JDWPViewThread;

public enum JDWPHostCommandSetStackFrame implements JDWPCommandHandler
{
    GET_VALUES(JDWPCommandSetStackFrame.GET_VALUES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object thread = __controller.readThread(__packet);
            Object frame = __controller.readFrame(__packet, false);
            JDWPViewThread viewThread = __controller.viewThread();
            if (viewThread.suspension(thread).query() <= 0) {
                throw new JDWPCommandException(JDWPErrorType.THREAD_NOT_SUSPENDED);
            }
            int numSlots = __packet.readInt();
            int[] wantSlot = new int[numSlots];
            byte[] wantTag = new byte[numSlots];
            for (int i2 = 0; i2 < numSlots; ++i2) {
                wantSlot[i2] = __packet.readInt();
                wantTag[i2] = __packet.readByte();
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(numSlots);
            JDWPViewFrame viewFrame = __controller.viewFrame();
            for (int i3 = 0; i3 < numSlots; ++i3) {
                try (JDWPHostValue value = __controller.value();){
                    if (!viewFrame.readValue(frame, wantSlot[i3], value)) {
                        value.set(null);
                    }
                    JDWPValueTag tag = __controller.guessType(value);
                    __controller.writeValue(rv, value, tag, false);
                    if (value.get() == null || !tag.isObject) continue;
                    __controller.getState().items.put(value.get());
                    continue;
                }
                catch (IndexOutOfBoundsException __e) {
                    throw new JDWPCommandException(JDWPErrorType.INVALID_SLOT, "IOOB", __e);
                }
            }
            return rv;
        }
    }
    ,
    THIS_OBJECT(JDWPCommandSetStackFrame.THIS_OBJECT){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object thread = __controller.readThread(__packet);
            Object frame = __controller.readFrame(__packet, false);
            JDWPViewThread viewThread = __controller.viewThread();
            if (viewThread.suspension(thread).query() <= 0) {
                throw new JDWPCommandException(JDWPErrorType.THREAD_NOT_SUSPENDED);
            }
            JDWPViewFrame viewFrame = __controller.viewFrame();
            Object type = viewFrame.atClass(frame);
            int methodDx = viewFrame.atMethodIndex(frame);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            int mFlags = __controller.viewType().methodFlags(type, methodDx);
            if (0 != (mFlags & 0x108)) {
                rv.writeId(0);
            } else {
                try (JDWPHostValue value = __controller.value();){
                    if (!viewFrame.readValue(frame, 0, value)) {
                        value.set(null);
                    }
                    JDWPValueTag tag = __controller.guessType(value);
                    __controller.writeValue(rv, value, tag, false);
                    if (value.get() != null && tag.isObject) {
                        __controller.getState().items.put(value.get());
                    }
                }
            }
            return rv;
        }
    };

    public final JDWPCommand command;
    static final int _FLAG_STATIC = 8;
    static final int _FLAG_NATIVE = 256;
    public final int id;

    private JDWPHostCommandSetStackFrame(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }
}

