/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetThreadGroupReference;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostUtils;
import cc.squirreljme.jdwp.host.views.JDWPViewThread;
import cc.squirreljme.jdwp.host.views.JDWPViewThreadGroup;
import java.util.ArrayList;

public enum JDWPHostCommandSetThreadGroupReference implements JDWPCommandHandler
{
    NAME(JDWPCommandSetThreadGroupReference.NAME){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThreadGroup view = __controller.viewThreadGroup();
            Object group = __controller.readThreadGroup(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeString(view.name(group));
            return rv;
        }
    }
    ,
    PARENT(JDWPCommandSetThreadGroupReference.PARENT){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            __controller.readThreadGroup(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeId(0);
            return rv;
        }
    }
    ,
    CHILDREN(JDWPCommandSetThreadGroupReference.CHILDREN){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThreadGroup groupView = __controller.viewThreadGroup();
            JDWPViewThread threadView = __controller.viewThread();
            Object group = __controller.readThreadGroup(__packet, false);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            ArrayList<Object> threads = new ArrayList<Object>();
            for (Object thread : groupView.threads(group)) {
                if (!JDWPHostUtils.isVisibleThread(threadView, thread)) continue;
                threads.add(thread);
            }
            rv.writeInt(threads.size());
            for (Object e2 : threads) {
                Object threadInstance = threadView.instance(e2);
                __controller.writeObject(rv, threadInstance);
                __controller.getState().items.put(e2);
                __controller.getState().items.put(threadInstance);
            }
            rv.writeInt(0);
            return rv;
        }
    };

    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetThreadGroupReference(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }
}

