/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandException;
import cc.squirreljme.jdwp.JDWPCommandSetThreadReference;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.views.JDWPViewFrame;
import cc.squirreljme.jdwp.host.views.JDWPViewThread;
import cc.squirreljme.jdwp.host.views.JDWPViewThreadGroup;

public enum JDWPHostCommandSetThreadReference implements JDWPCommandHandler
{
    NAME(JDWPCommandSetThreadReference.NAME){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object thread = __controller.readThread(__packet);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeString(__controller.viewThread().name(thread));
            return rv;
        }
    }
    ,
    SUSPEND(JDWPCommandSetThreadReference.SUSPEND){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThread view = __controller.viewThread();
            Object thread = __controller.readThread(__packet);
            view.suspension(thread).suspend();
            return null;
        }
    }
    ,
    RESUME(JDWPCommandSetThreadReference.RESUME){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThread view = __controller.viewThread();
            Object thread = __controller.readThread(__packet);
            view.suspension(thread).resume();
            return null;
        }
    }
    ,
    STATUS(JDWPCommandSetThreadReference.STATUS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThread view = __controller.viewThread();
            Object thread = __controller.readThread(__packet);
            if (thread == null) {
                JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
                rv.writeInt(0);
                rv.writeInt(0);
                return rv;
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            boolean terminated = view.isTerminated(thread);
            if (terminated) {
                rv.writeInt(0);
            } else {
                switch (view.status(thread)) {
                    case 1: {
                        rv.writeInt(2);
                        break;
                    }
                    case 2: {
                        rv.writeInt(3);
                        break;
                    }
                    default: {
                        rv.writeInt(1);
                    }
                }
            }
            rv.writeInt(!terminated && view.suspension(thread).query() > 0 ? 1 : 0);
            return rv;
        }
    }
    ,
    THREAD_GROUP(JDWPCommandSetThreadReference.THREAD_GROUP){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThread viewThread = __controller.viewThread();
            JDWPViewThreadGroup viewThreadGroup = __controller.viewThreadGroup();
            Object thread = __controller.readThread(__packet);
            Object parent = viewThread.parentGroup(thread);
            Object parentInstance = viewThreadGroup.instance(parent);
            __controller.getState().items.put(parent);
            __controller.getState().items.put(parentInstance);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            __controller.writeObject(rv, parentInstance);
            return rv;
        }
    }
    ,
    FRAMES(JDWPCommandSetThreadReference.FRAMES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object thread = __controller.readThread(__packet);
            JDWPViewThread viewThread = __controller.viewThread();
            if (viewThread.suspension(thread).query() <= 0) {
                throw new JDWPCommandException(JDWPErrorType.THREAD_NOT_SUSPENDED);
            }
            int startFrame = __packet.readInt();
            int count = __packet.readInt();
            Object[] frames = viewThread.frames(thread);
            count = count == -1 ? Math.max(0, frames.length - startFrame) : Math.min(count, frames.length - startFrame);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(count);
            JDWPViewFrame viewFrame = __controller.viewFrame();
            int i2 = startFrame;
            for (int j2 = 0; j2 < count; ++j2) {
                Object frame = frames[i2];
                __controller.getState().items.put(frame);
                __controller.writeObject(rv, frame);
                Object classy = viewFrame.atClass(frame);
                if (classy != null) {
                    __controller.getState().items.put(classy);
                }
                int atMethodIndex = viewFrame.atMethodIndex(frame);
                __controller.writeLocation(rv, classy, atMethodIndex, viewFrame.atCodeIndex(frame));
                ++i2;
            }
            return rv;
        }
    }
    ,
    FRAME_COUNT(JDWPCommandSetThreadReference.FRAME_COUNT){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object thread = __controller.readThread(__packet);
            JDWPViewThread viewThread = __controller.viewThread();
            if (viewThread.suspension(thread).query() <= 0) {
                throw new JDWPCommandException(JDWPErrorType.THREAD_NOT_SUSPENDED);
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(viewThread.frames(thread).length);
            return rv;
        }
    }
    ,
    STOP(JDWPCommandSetThreadReference.STOP){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            Object thread = __controller.readThread(__packet);
            throw JDWPErrorType.ILLEGAL_ARGUMENT.toss(thread, System.identityHashCode(thread), null);
        }
    }
    ,
    INTERRUPT(JDWPCommandSetThreadReference.INTERRUPT){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThread view = __controller.viewThread();
            Object thread = __controller.readThread(__packet);
            view.interrupt(thread);
            return null;
        }
    }
    ,
    SUSPEND_COUNT(JDWPCommandSetThreadReference.SUSPEND_COUNT){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThread view = __controller.viewThread();
            Object thread = __controller.readThread(__packet);
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(view.suspension(thread).query());
            return rv;
        }
    };

    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetThreadReference(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }
}

