/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetVirtualMachine;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPIdSizes;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostThreadSuspension;
import cc.squirreljme.jdwp.host.views.JDWPViewHasInstance;
import cc.squirreljme.jdwp.host.views.JDWPViewThread;
import cc.squirreljme.jdwp.host.views.JDWPViewThreadGroup;
import cc.squirreljme.jdwp.host.views.JDWPViewType;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum JDWPHostCommandSetVirtualMachine implements JDWPCommandHandler
{
    VERSION(JDWPCommandSetVirtualMachine.VERSION){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeString(__controller.bind().vmDescription());
            rv.writeInt(1);
            rv.writeInt(7);
            rv.writeString(__controller.bind().vmVersion());
            rv.writeString(__controller.bind().vmName());
            return rv;
        }
    }
    ,
    CLASSES_BY_SIGNATURE(JDWPCommandSetVirtualMachine.CLASSES_BY_SIGNATURE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            String wantSig = __packet.readString();
            LinkedList<Object> found = new LinkedList<Object>();
            JDWPViewType viewType = __controller.viewType();
            for (Object type : __controller.allTypes(false)) {
                if (!wantSig.equals(viewType.signature(type))) continue;
                found.add(type);
            }
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeInt(found.size());
            for (Object e2 : found) {
                __controller.getState().items.put(e2);
                __controller.writeTaggedId(rv, e2);
                rv.writeInt(4);
            }
            return rv;
        }
    }
    ,
    ALL_CLASSES(JDWPCommandSetVirtualMachine.ALL_CLASSES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return JDWPHostCommandSetVirtualMachine.__allClasses(__controller, __packet, false);
        }
    }
    ,
    ALL_THREADS(JDWPCommandSetVirtualMachine.ALL_THREADS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return JDWPHostCommandSetVirtualMachine.__writeInstances(__controller, __packet, __controller.viewThread(), __controller.allThreads(true));
        }
    }
    ,
    TOP_LEVEL_THREAD_GROUPS(JDWPCommandSetVirtualMachine.TOP_LEVEL_THREAD_GROUPS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return JDWPHostCommandSetVirtualMachine.__writeInstances(__controller, __packet, __controller.viewThreadGroup(), __controller.allThreadGroups());
        }
    }
    ,
    DISPOSE(JDWPCommandSetVirtualMachine.DISPOSE){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            try {
                __controller.close();
            }
            finally {
                try {
                    JDWPViewThread viewThread = __controller.viewThread();
                    for (Object thread : __controller.allThreads(false)) {
                        JDWPHostThreadSuspension suspension = viewThread.suspension(thread);
                        while (suspension.query() > 0) {
                            suspension.resume();
                        }
                    }
                }
                finally {
                    __controller.getEventManager().clearAll();
                }
            }
            return null;
        }
    }
    ,
    ID_SIZES(JDWPCommandSetVirtualMachine.ID_SIZES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            JDWPIdSizes idSizes = __packet.idSizes();
            for (int i2 = 0; i2 < 5; ++i2) {
                rv.writeInt(idSizes.getSize(i2));
            }
            return rv;
        }
    }
    ,
    SUSPEND(JDWPCommandSetVirtualMachine.SUSPEND){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThread view = __controller.viewThread();
            for (Object thread : __controller.allThreads(false)) {
                view.suspension(thread).suspend();
            }
            return null;
        }
    }
    ,
    RESUME(JDWPCommandSetVirtualMachine.RESUME){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPViewThread view = __controller.viewThread();
            for (Object thread : __controller.allThreads(false)) {
                view.suspension(thread).resume();
            }
            return null;
        }
    }
    ,
    EXIT(JDWPCommandSetVirtualMachine.EXIT){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            int code = __packet.readInt();
            JDWPViewThreadGroup view = __controller.viewThreadGroup();
            for (Object threadGroup : __controller.allThreadGroups()) {
                view.exit(threadGroup, code);
            }
            return null;
        }
    }
    ,
    CAPABILITIES(JDWPCommandSetVirtualMachine.CAPABILITIES){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__capabilities(false, __controller, __packet);
        }
    }
    ,
    CLASS_PATHS(JDWPCommandSetVirtualMachine.CLASS_PATHS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
            rv.writeString(".");
            rv.writeInt(0);
            String[] classPaths = __controller.bind().debuggerLibraries();
            rv.writeInt(classPaths.length);
            for (String p2 : classPaths) {
                rv.writeString(p2);
            }
            return rv;
        }
    }
    ,
    HOLD_EVENTS(JDWPCommandSetVirtualMachine.HOLD_EVENTS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            __controller.setHoldingEvents(true);
            return null;
        }
    }
    ,
    RELEASE_EVENTS(JDWPCommandSetVirtualMachine.RELEASE_EVENTS){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            __controller.setHoldingEvents(false);
            return null;
        }
    }
    ,
    CAPABILITIES_NEW(JDWPCommandSetVirtualMachine.CAPABILITIES_NEW){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return this.__capabilities(true, __controller, __packet);
        }
    }
    ,
    ALL_CLASSES_WITH_GENERIC_SIGNATURE(JDWPCommandSetVirtualMachine.ALL_CLASSES_WITH_GENERIC_SIGNATURE){

        @Override
        public JDWPPacket execute(JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
            return JDWPHostCommandSetVirtualMachine.__allClasses(__controller, __packet, true);
        }
    };

    private static final int _CLASS_INITIALIZED = 4;
    public final JDWPCommand command;
    public final int id;

    private JDWPHostCommandSetVirtualMachine(JDWPCommand __id) {
        this.command = __id;
        this.id = __id.debuggerId();
    }

    @Override
    public final JDWPCommand command() {
        return this.command;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }

    @NotNull
    private static JDWPPacket __allClasses(JDWPHostController __controller, JDWPPacket __packet, boolean __generic) {
        List<Object> allTypes = __controller.allTypes(false);
        if (allTypes.isEmpty()) {
            JDWPViewThreadGroup viewGroup = __controller.viewThreadGroup();
            for (Object group : __controller.allThreadGroups()) {
                Object type = viewGroup.findType(group, "java/lang/Object");
                if (type == null) continue;
                allTypes.add(type);
                __controller.getState().items.put(type);
                break;
            }
            if (allTypes.isEmpty()) {
                throw JDWPErrorType.VM_DEAD.toss(null, 0);
            }
        }
        JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
        JDWPViewType viewType = __controller.viewType();
        rv.writeInt(allTypes.size());
        for (Object type : allTypes) {
            __controller.writeTaggedId(rv, type);
            rv.writeString(viewType.signature(type));
            if (__generic) {
                rv.writeString("");
            }
            rv.writeInt(4);
        }
        return rv;
    }

    JDWPPacket __capabilities(boolean __new, JDWPHostController __controller, JDWPPacket __packet) throws JDWPException {
        JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
        rv.writeBoolean(true);
        rv.writeBoolean(true);
        rv.writeBoolean(true);
        rv.writeBoolean(false);
        rv.writeBoolean(false);
        rv.writeBoolean(false);
        rv.writeBoolean(false);
        if (__new) {
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(false);
            rv.writeBoolean(true);
            rv.writeBoolean(false);
            for (int i2 = 22; i2 <= 32; ++i2) {
                rv.writeBoolean(false);
            }
        }
        return rv;
    }

    static JDWPPacket __writeInstances(JDWPHostController __controller, JDWPPacket __packet, JDWPViewHasInstance __viewInstance, Object[] __objects) {
        JDWPPacket rv = __controller.reply(__packet.id(), JDWPErrorType.NO_ERROR);
        rv.writeInt(__objects.length);
        for (Object object : __objects) {
            Object objectInstance = __viewInstance.instance(object);
            __controller.writeObject(rv, objectInstance);
            __controller.getState().items.put(object);
            __controller.getState().items.put(objectInstance);
        }
        return rv;
    }
}

