/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPClassStatus;
import cc.squirreljme.jdwp.JDWPCommLink;
import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandException;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPEventKind;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPIdSizes;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPSuspendPolicy;
import cc.squirreljme.jdwp.JDWPValueTag;
import cc.squirreljme.jdwp.host.JDWPCommandHandler;
import cc.squirreljme.jdwp.host.JDWPHostBinding;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetArrayReference;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetClassLoader;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetClassObjectReference;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetClassType;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetEventRequest;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetMethod;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetObjectReference;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetReferenceType;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetStackFrame;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetStringReference;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetThreadGroupReference;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetThreadReference;
import cc.squirreljme.jdwp.host.JDWPHostCommandSetVirtualMachine;
import cc.squirreljme.jdwp.host.JDWPHostEventKindHandler;
import cc.squirreljme.jdwp.host.JDWPHostEventManager;
import cc.squirreljme.jdwp.host.JDWPHostEventRequest;
import cc.squirreljme.jdwp.host.JDWPHostLinker;
import cc.squirreljme.jdwp.host.JDWPHostLocation;
import cc.squirreljme.jdwp.host.JDWPHostState;
import cc.squirreljme.jdwp.host.JDWPHostStepTracker;
import cc.squirreljme.jdwp.host.JDWPHostUtils;
import cc.squirreljme.jdwp.host.JDWPHostValue;
import cc.squirreljme.jdwp.host.__TripBreakpoint__;
import cc.squirreljme.jdwp.host.__TripClassStatus__;
import cc.squirreljme.jdwp.host.__TripField__;
import cc.squirreljme.jdwp.host.__TripThreadAlive__;
import cc.squirreljme.jdwp.host.__TripVmState__;
import cc.squirreljme.jdwp.host.event.JDWPHostCallStackStepping;
import cc.squirreljme.jdwp.host.event.JDWPHostEventFilter;
import cc.squirreljme.jdwp.host.event.JDWPHostFieldOnly;
import cc.squirreljme.jdwp.host.trips.JDWPGlobalTrip;
import cc.squirreljme.jdwp.host.trips.JDWPTrip;
import cc.squirreljme.jdwp.host.views.JDWPView;
import cc.squirreljme.jdwp.host.views.JDWPViewFrame;
import cc.squirreljme.jdwp.host.views.JDWPViewHasInstance;
import cc.squirreljme.jdwp.host.views.JDWPViewKind;
import cc.squirreljme.jdwp.host.views.JDWPViewObject;
import cc.squirreljme.jdwp.host.views.JDWPViewThread;
import cc.squirreljme.jdwp.host.views.JDWPViewThreadGroup;
import cc.squirreljme.jdwp.host.views.JDWPViewType;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.multiphasicapps.collections.UnmodifiableMap;

public final class JDWPHostController
implements Closeable,
Runnable {
    static final boolean _DEBUG = Boolean.getBoolean("cc.squirreljme.jdwp.debug");
    private static final JDWPViewKind[] _INSTANCE_CAPTURE = new JDWPViewKind[]{JDWPViewKind.THREAD, JDWPViewKind.THREAD_GROUP, JDWPViewKind.TYPE};
    private static final Map<JDWPCommand, JDWPCommandHandler> _HANDLERS;
    protected final JDWPCommLink commLink;
    protected final JDWPHostState state;
    protected final JDWPHostEventManager eventManager = new JDWPHostEventManager();
    private final Reference<JDWPHostBinding> _bind;
    private final Object _nextIdMonitor = new Object();
    private final Deque<JDWPHostValue> _freeValues = new LinkedList<JDWPHostValue>();
    private final JDWPTrip[] _trips = new JDWPTrip[JDWPGlobalTrip.values().length];
    private final Reference<JDWPHostController> _weakThis = new WeakReference<JDWPHostController>(this);
    private final Queue<JDWPPacket> _heldPackets = new LinkedList<JDWPPacket>();
    private volatile boolean _holdEvents;
    private volatile boolean _closed;

    private static void __fillIn(Map<JDWPCommand, JDWPCommandHandler> __handlers, JDWPCommandHandler[] __impls) throws NullPointerException {
        if (__handlers == null || __impls == null) {
            throw new NullPointerException("NARG");
        }
        for (JDWPCommandHandler impl : __impls) {
            __handlers.put(impl.command(), impl);
        }
    }

    public JDWPHostController(JDWPHostBinding __bind, InputStream __in, OutputStream __out) throws NullPointerException {
        if (__bind == null || __in == null || __out == null) {
            throw new NullPointerException("NARG");
        }
        this._bind = new WeakReference<JDWPHostBinding>(__bind);
        this.state = new JDWPHostState(new WeakReference<JDWPHostBinding>(__bind));
        this.commLink = new JDWPCommLink(__in, __out);
        this.getCommLink().setIdSizes(new JDWPIdSizes(4, 4, 4, 4, 4));
        Thread thread = new Thread(this, "JDWPController");
        thread.start();
    }

    public final Object[] allThreads(boolean __filterVisible) {
        JDWPHostState state = this.getState();
        JDWPViewThreadGroup groupView = state.view(JDWPViewThreadGroup.class, JDWPViewKind.THREAD_GROUP);
        JDWPViewThread threadView = state.view(JDWPViewThread.class, JDWPViewKind.THREAD);
        ArrayList allThreads = new ArrayList();
        for (Object group : this.bind().debuggerThreadGroups()) {
            state.items.put(group);
            state.items.put(groupView.instance(group));
            ArrayList<Object> threads = new ArrayList<Object>();
            for (Object thread : groupView.threads(group)) {
                if (__filterVisible && !JDWPHostUtils.isVisibleThread(threadView, thread)) continue;
                threads.add(thread);
            }
            for (Object e2 : threads) {
                state.items.put(e2);
                Object threadInstance = threadView.instance(e2);
                if (threadInstance == null) continue;
                state.items.put(threadInstance);
            }
            allThreads.ensureCapacity(allThreads.size() + threads.size());
            allThreads.addAll(threads);
        }
        return allThreads.toArray(new Object[allThreads.size()]);
    }

    public List<Object> allTypes(boolean __cached) {
        LinkedList<Object> allTypes = new LinkedList<Object>();
        if (__cached) {
            JDWPViewType viewType = this.viewType();
            for (Object obj : this.getState().items.values()) {
                if (!viewType.isValid(obj)) continue;
                allTypes.add(obj);
            }
        } else {
            for (Object group : this.allThreadGroups()) {
                allTypes.addAll(this.allTypes(group));
            }
        }
        return allTypes;
    }

    public List<Object> allTypes(Object __group) throws NullPointerException {
        if (__group == null) {
            throw new NullPointerException("NARG");
        }
        Object[] types = this.viewThreadGroup().allTypes(__group);
        JDWPHostLinker<Object> items = this.getState().items;
        for (Object type : types) {
            items.put(type);
        }
        return Arrays.asList(types);
    }

    public final Object[] allThreadGroups() {
        Object[] groups = this.bind().debuggerThreadGroups();
        JDWPHostState state = this.getState();
        for (Object group : groups) {
            state.items.put(group);
        }
        return groups;
    }

    public JDWPHostBinding bind() throws JDWPException {
        JDWPHostBinding rv = this._bind.get();
        if (rv == null) {
            throw new JDWPException("AG0h");
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        JDWPHostController jDWPHostController = this;
        synchronized (jDWPHostController) {
            if (this._closed) {
                return;
            }
            this._closed = true;
        }
        try {
            this.getCommLink().close();
        }
        finally {
            jDWPHostController = this;
            synchronized (jDWPHostController) {
                Queue<JDWPPacket> heldPackets = this._heldPackets;
                while (!heldPackets.isEmpty()) {
                    heldPackets.poll().close();
                }
            }
        }
    }

    public JDWPCommandHandler commandHandler(JDWPCommandSet __commandSet, int __command) {
        if (__commandSet == null) {
            return null;
        }
        return this.commandHandler(__commandSet.command(__command));
    }

    public JDWPCommandHandler commandHandler(JDWPCommand __command) throws NullPointerException {
        return _HANDLERS.get(__command);
    }

    public JDWPPacket event(JDWPSuspendPolicy __policy, JDWPEventKind __kind, int __responseId) throws NullPointerException {
        if (__policy == null || __kind == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket rv = this.getCommLink().request(64, 100);
        rv.writeByte(__policy.id);
        rv.writeInt(1);
        rv.writeByte(__kind.id);
        rv.writeInt(__responseId);
        return rv;
    }

    public JDWPCommLink getCommLink() {
        return this.commLink;
    }

    public JDWPHostEventManager getEventManager() {
        return this.eventManager;
    }

    public JDWPHostState getState() {
        return this.state;
    }

    public JDWPValueTag guessType(JDWPHostValue __value) throws NullPointerException {
        if (__value == null) {
            throw new NullPointerException("NARG");
        }
        if (!__value.isSet()) {
            return JDWPValueTag.VOID;
        }
        return this.guessTypeRaw(__value.get());
    }

    public JDWPValueTag guessTypeRaw(Object __value) throws NullPointerException {
        if (__value == null || this.viewObject().isNullObject(__value)) {
            return JDWPValueTag.OBJECT;
        }
        if (this.viewObject().isValid(__value)) {
            return JDWPValueTag.fromSignature(this.viewType().signature(this.viewObject().type(__value)));
        }
        if (__value instanceof Boolean) {
            return JDWPValueTag.BOOLEAN;
        }
        if (__value instanceof Byte) {
            return JDWPValueTag.BYTE;
        }
        if (__value instanceof Short) {
            return JDWPValueTag.SHORT;
        }
        if (__value instanceof Character) {
            return JDWPValueTag.CHARACTER;
        }
        if (__value instanceof Integer) {
            return JDWPValueTag.INTEGER;
        }
        if (__value instanceof Long) {
            return JDWPValueTag.LONG;
        }
        if (__value instanceof Float) {
            return JDWPValueTag.FLOAT;
        }
        if (__value instanceof Double) {
            return JDWPValueTag.DOUBLE;
        }
        return JDWPValueTag.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHoldingEvents() {
        JDWPHostController jDWPHostController = this;
        synchronized (jDWPHostController) {
            return this._holdEvents;
        }
    }

    public JDWPHostLocation locationOf(Object __thread) {
        JDWPViewType viewType = this.viewType();
        JDWPViewThread viewThread = this.viewThread();
        JDWPViewFrame viewFrame = this.viewFrame();
        Object[] frames = viewThread.frames(__thread);
        if (frames == null || frames.length == 0) {
            return JDWPHostLocation.BLANK;
        }
        Object topFrame = frames[0];
        Object type = viewFrame.atClass(topFrame);
        int methodDx = viewFrame.atMethodIndex(topFrame);
        JDWPHostLinker<Object> items = this.getState().items;
        if (topFrame != null) {
            items.put(topFrame);
        }
        if (type != null) {
            items.put(type);
        }
        return new JDWPHostLocation(type, methodDx, viewFrame.atCodeIndex(topFrame), viewType.methodName(type, methodDx), viewType.methodSignature(type, methodDx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean poll() throws JDWPException {
        commLink = this.getCommLink();
        while (true) lbl-1000:
        // 13 sources

        {
            block50: {
                var3_3 = this;
                synchronized (var3_3) {
                    if (this._closed) {
                        return false;
                    }
                    if (this.isHoldingEvents()) {
                        break block50;
                    }
                    packet = this._heldPackets.poll();
                }
                if (packet != null) {
                    ignored = packet;
                    var4_4 = null;
                    try {
                        commLink.send(packet);
                    }
                    catch (Throwable var5_12) {
                        var4_4 = var5_12;
                        throw var5_12;
                    }
                    finally {
                        if (ignored == null) ** GOTO lbl-1000
                        if (var4_4 != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable var5_11) {
                                var4_4.addSuppressed(var5_11);
                            }
                        }
                        ignored.close();
                    }
                    continue;
                }
            }
            packet = commLink.poll();
            var3_3 = null;
            try {
                if (packet == null) break;
                if (JDWPHostController._DEBUG) {
                    Debugging.debugNote("JDWP: <- %s", new Object[]{packet});
                }
                if (packet.isReply()) continue;
                command = this.commandHandler(packet.commandSet(), packet.command());
                if (command == null) {
                    result = this.reply(packet.id(), JDWPErrorType.NOT_IMPLEMENTED);
                } else {
                    try {
                        result = command.execute(this, packet);
                        if (result == null) {
                            result = this.reply(packet.id(), JDWPErrorType.NO_ERROR);
                        }
                    }
                    catch (JDWPCommandException e) {
                        if (JDWPHostController._DEBUG) {
                            e.printStackTrace();
                        }
                        result = this.reply(packet.id(), e.type);
                    }
                }
                ignored = result;
                var7_16 = null;
                try {
                    commLink.send(result);
                    continue;
                }
                catch (Throwable var8_19) {
                    var7_16 = var8_19;
                    throw var8_19;
                }
                finally {
                    if (ignored == null) continue;
                    if (var7_16 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable var8_18) {
                            var7_16.addSuppressed(var8_18);
                        }
                        continue;
                    }
                    ignored.close();
                    continue;
                }
            }
            catch (Throwable var4_9) {
                var3_3 = var4_9;
                throw var4_9;
            }
            finally {
                if (packet == null) continue;
                if (var3_3 != null) {
                    try {
                        packet.close();
                    }
                    catch (Throwable var4_6) {
                        var3_3.addSuppressed(var4_6);
                    }
                    continue;
                }
                packet.close();
                continue;
            }
            break;
        }
        return true;
    }

    public final Object readArray(JDWPPacket __packet, boolean __nullable) throws JDWPException {
        Object object = this.readObject(__packet, __nullable);
        if (this.viewObject().arrayLength(object) < 0) {
            if (__nullable && object == null) {
                return null;
            }
            throw JDWPErrorType.INVALID_ARRAY.toss(object, System.identityHashCode(object));
        }
        return object;
    }

    public Object readFrame(JDWPPacket __packet, boolean __nullable) {
        int id = __packet.readId();
        Object frame = this.getState().items.get(id);
        if (!this.viewFrame().isValid(frame)) {
            if (__nullable && frame == null) {
                return null;
            }
            throw JDWPErrorType.INVALID_FRAME_ID.toss(frame, id);
        }
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPHostLocation readLocation(JDWPPacket __packet) throws JDWPException {
        JDWPPacket jDWPPacket = __packet;
        synchronized (jDWPPacket) {
            int methodDx;
            Object type;
            byte tag = __packet.readByte();
            if (tag == 0) {
                return JDWPHostLocation.BLANK;
            }
            JDWPViewType viewType = this.viewType();
            if (!viewType.isValidMethod(type = this.readType(__packet, false), methodDx = __packet.readId())) {
                throw JDWPErrorType.INVALID_METHOD_ID.toss(type, methodDx, null);
            }
            return new JDWPHostLocation(type, methodDx, __packet.readLong(), viewType.methodName(type, methodDx), viewType.methodSignature(type, methodDx));
        }
    }

    public final Object readObject(JDWPPacket __packet, boolean __nullable) throws JDWPException {
        int id = __packet.readId();
        Object object = this.getState().items.get(id);
        if (!this.viewObject().isValid(object)) {
            Object alt;
            if (this.viewThread().isValid(object)) {
                alt = this.viewThread().instance(object);
                if (this.viewObject().isValid(alt)) {
                    this.getState().items.put(alt);
                    return alt;
                }
            }
            if (this.viewThreadGroup().isValid(object)) {
                alt = this.viewThreadGroup().instance(object);
                if (this.viewObject().isValid(alt)) {
                    this.getState().items.put(alt);
                    return alt;
                }
            }
            if (this.viewType().isValid(object)) {
                alt = this.viewType().instance(object);
                if (this.viewObject().isValid(alt)) {
                    this.getState().items.put(alt);
                    return alt;
                }
            }
            if (__nullable && object == null) {
                return null;
            }
            throw JDWPErrorType.INVALID_OBJECT.toss(object, id);
        }
        return object;
    }

    public final Object readThread(JDWPPacket __packet) throws JDWPException {
        JDWPViewObject viewObject = this.viewObject();
        JDWPViewThread viewThread = this.viewThread();
        JDWPViewType viewType = this.viewType();
        int id = __packet.readId();
        Object thread = this.getState().items.get(id);
        if (!viewThread.isValid(thread)) {
            if (viewObject.isValid(thread)) {
                int fieldId;
                for (Object check : this.allThreads(false)) {
                    if (thread != viewThread.instance(check)) continue;
                    this.getState().items.put(check);
                    return check;
                }
                Object objType = viewObject.type(thread);
                if ("Ljava/lang/Thread;".equals(viewType.signature(objType)) && (fieldId = JDWPHostUtils.findFieldId(viewType, objType, "_vmThread", "Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;")) >= 0) {
                    try (JDWPHostValue value = this.value();){
                        if (viewObject.readValue(thread, fieldId, value)) {
                            Object object = viewThread.fromBracket(value.get());
                            return object;
                        }
                    }
                }
            }
            throw JDWPErrorType.INVALID_THREAD.toss(thread, id);
        }
        return thread;
    }

    public final Object readThreadGroup(JDWPPacket __packet, boolean __nullable) throws JDWPException {
        int id = __packet.readId();
        Object group = this.getState().items.get(id);
        JDWPViewThreadGroup viewThreadGroup = this.viewThreadGroup();
        if (!this.viewThreadGroup().isValid(group)) {
            if (this.viewObject().isValid(group)) {
                for (Object check : this.allThreadGroups()) {
                    if (group != viewThreadGroup.instance(check)) continue;
                    this.getState().items.put(check);
                    return check;
                }
            }
            if (__nullable && group == null) {
                return null;
            }
            throw JDWPErrorType.INVALID_THREAD.toss(group, id);
        }
        return group;
    }

    public final Object readType(JDWPPacket __packet, boolean __nullable) throws JDWPException {
        int id = __packet.readId();
        Object object = this.getState().items.get(id);
        if (!this.viewType().isValid(object)) {
            if (this.viewObject().isValid(object)) {
                Object alt = this.viewObject().type(object);
                if (this.viewType().isValid(alt)) {
                    this.getState().items.put(alt);
                    return alt;
                }
            }
            if (__nullable && object == null) {
                return null;
            }
            throw JDWPErrorType.INVALID_CLASS.toss(object, id);
        }
        return object;
    }

    public final JDWPPacket reply(int __id, JDWPErrorType __error) {
        return this.getCommLink().reply(__id, __error);
    }

    @Override
    public void run() {
        try (JDWPHostController ignored = this;){
            JDWPCommLink commLink = this.getCommLink();
            while (!commLink.isShutdown()) {
                this.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHoldingEvents(boolean __hold) {
        JDWPHostController jDWPHostController = this;
        synchronized (jDWPHostController) {
            this._holdEvents = __hold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean signal(Object __thread, JDWPEventKind __kind, Object ... __args) throws NullPointerException {
        if (__kind == null) {
            throw new NullPointerException("NARG");
        }
        if (__thread != null) {
            this.getState().items.put(__thread);
        }
        boolean unconditional = false;
        if (__kind == JDWPEventKind.UNCONDITIONAL_BREAKPOINT) {
            unconditional = true;
            __kind = JDWPEventKind.BREAKPOINT;
        }
        boolean hit = false;
        Iterator<JDWPHostEventRequest> iterator = this.getEventManager().find(this, __thread, unconditional, __kind, __args).iterator();
        while (iterator.hasNext()) {
            JDWPHostEventRequest request = iterator.next();
            if (request.suspendPolicy == JDWPSuspendPolicy.ALL) {
                for (Object thread : this.allThreads(false)) {
                    this.viewThread().suspension(thread).suspend();
                }
            } else if (request.suspendPolicy == JDWPSuspendPolicy.EVENT_THREAD && __thread != null) {
                this.viewThread().suspension(__thread).suspend();
            }
            hit = true;
            JDWPPacket packet = this.event(request.suspendPolicy, __kind, request.id);
            Throwable throwable = null;
            try {
                if (_DEBUG) {
                    Debugging.debugNote("JDWP: Event #%d %s", request.id, __kind);
                }
                JDWPHostEventKindHandler.of(__kind.debuggerId()).write(this, __thread, packet, __args);
                JDWPHostController jDWPHostController = this;
                synchronized (jDWPHostController) {
                    if (this.isHoldingEvents()) {
                        this._heldPackets.add(this.getCommLink().getPacket().copyOf(packet));
                        continue;
                    }
                }
                this.getCommLink().send(packet);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (packet == null) continue;
                if (throwable != null) {
                    try {
                        packet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                packet.close();
                continue;
            }
            break;
        }
        return hit;
    }

    public final <T extends JDWPTrip> T trip(Class<T> __cl, JDWPGlobalTrip __t) throws NullPointerException {
        if (__cl == null || __t == null) {
            throw new NullPointerException("NARG");
        }
        JDWPTrip[] trips = this._trips;
        JDWPTrip trip = trips[__t.ordinal()];
        if (trip != null) {
            return (T)((JDWPTrip)__cl.cast(trip));
        }
        Reference<JDWPHostController> ref = this._weakThis;
        switch (__t) {
            case CLASS_STATUS: {
                trip = new __TripClassStatus__(ref);
                break;
            }
            case FIELD: {
                trip = new __TripField__(ref);
                break;
            }
            case VM_STATE: {
                trip = new __TripVmState__(ref);
                break;
            }
            case THREAD: {
                trip = new __TripThreadAlive__(ref);
                break;
            }
            default: {
                throw Debugging.oops(new Object[]{__t});
            }
        }
        this._trips[__t.ordinal()] = trip;
        return (T)((JDWPTrip)__cl.cast(trip));
    }

    public void tripRequest(JDWPHostEventRequest __request) throws NullPointerException {
        if (__request == null) {
            throw new NullPointerException("NARG");
        }
        Reference<JDWPHostController> ref = this._weakThis;
        JDWPHostEventFilter filter = __request.filter;
        switch (__request.eventKind) {
            case BREAKPOINT: {
                JDWPHostLocation location = filter.location;
                if (location == null) {
                    return;
                }
                this.viewType().methodBreakpoint(location.type, location.methodDx, (int)location.codeDx, new __TripBreakpoint__(ref));
                break;
            }
            case FIELD_ACCESS: 
            case FIELD_MODIFICATION: {
                JDWPHostFieldOnly fieldOnly = filter.fieldOnly;
                if (fieldOnly == null) {
                    return;
                }
                this.viewType().fieldWatch(fieldOnly.type, fieldOnly.fieldDx, __request.eventKind == JDWPEventKind.FIELD_MODIFICATION);
                break;
            }
            case SINGLE_STEP: {
                JDWPHostCallStackStepping stepping = filter.callStackStepping;
                if (stepping == null || stepping.thread == null) {
                    return;
                }
                if (filter.thread != null && filter.thread != stepping.thread) {
                    return;
                }
                JDWPHostStepTracker stepTracker = this.viewThread().stepTracker(stepping.thread);
                stepTracker.steppingSet(this, stepping.thread, stepping.size, stepping.depth);
                break;
            }
            case CLASS_PREPARE: {
                if (filter == null || !filter.hasTypeMatch()) {
                    return;
                }
                JDWPViewType viewType = this.viewType();
                for (Object type : this.allTypes(true)) {
                    if (!filter.meetsType(viewType, type)) continue;
                    this.signal(null, __request.eventKind, new Object[]{type, JDWPClassStatus.INITIALIZED});
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JDWPHostValue value() {
        Deque<JDWPHostValue> freeValues = this._freeValues;
        Deque<JDWPHostValue> deque = this._freeValues;
        synchronized (deque) {
            JDWPHostValue rv = freeValues.poll();
            if (rv != null) {
                return rv.__resetToOpen();
            }
            return new JDWPHostValue(freeValues).__resetToOpen();
        }
    }

    public final <V extends JDWPView> V view(Class<V> __type, JDWPViewKind __kind) {
        return this.getState().view(__type, __kind);
    }

    public final JDWPViewFrame viewFrame() {
        return this.getState().view(JDWPViewFrame.class, JDWPViewKind.FRAME);
    }

    public final JDWPViewObject viewObject() {
        return this.getState().view(JDWPViewObject.class, JDWPViewKind.OBJECT);
    }

    public final JDWPViewThread viewThread() {
        return this.getState().view(JDWPViewThread.class, JDWPViewKind.THREAD);
    }

    public final JDWPViewThreadGroup viewThreadGroup() {
        return this.getState().view(JDWPViewThreadGroup.class, JDWPViewKind.THREAD_GROUP);
    }

    public final JDWPViewType viewType() {
        return this.getState().view(JDWPViewType.class, JDWPViewKind.TYPE);
    }

    public void writeLocation(JDWPPacket __packet, JDWPHostLocation __location) throws JDWPException, NullPointerException {
        if (JDWPHostLocation.BLANK.equals(__location)) {
            __packet.writeByte(0);
            return;
        }
        this.writeLocation(__packet, __location.type, __location.methodDx, __location.codeDx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLocation(JDWPPacket __packet, Object __class, int __atMethodIndex, long __atCodeIndex) throws JDWPException, NullPointerException {
        if (__packet == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket jDWPPacket = __packet;
        synchronized (jDWPPacket) {
            this.writeTaggedId(__packet, __class);
            __packet.writeId(__atMethodIndex);
            __packet.writeLong(__atCodeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(JDWPPacket __packet, Object __instance) throws JDWPException, NullPointerException {
        if (__packet == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket jDWPPacket = __packet;
        synchronized (jDWPPacket) {
            JDWPViewObject viewObject = this.viewObject();
            if (__instance != null && viewObject.isNullObject(__instance)) {
                __instance = null;
            }
            if (__instance != null) {
                for (JDWPViewKind captureKind : _INSTANCE_CAPTURE) {
                    Object potential;
                    JDWPViewHasInstance viewInstance = this.view(JDWPViewHasInstance.class, captureKind);
                    if (!viewInstance.isValid(__instance) || (potential = viewInstance.instance(__instance)) == null || viewObject.isNullObject(potential)) continue;
                    this.getState().items.put(__instance);
                    this.getState().items.put(potential);
                    __instance = potential;
                    break;
                }
                if (!(viewObject.isValid(__instance) || this.viewType().isValid(__instance) || this.viewFrame().isValid(__instance) || this.viewThread().isValid(__instance) || this.viewThreadGroup().isValid(__instance))) {
                    throw JDWPErrorType.INVALID_OBJECT.toss(__instance, System.identityHashCode(__instance));
                }
            }
            __packet.writeId(System.identityHashCode(__instance));
            if (__instance != null) {
                this.getState().items.put(__instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTaggedId(JDWPPacket __packet, Object __object) throws JDWPException {
        JDWPPacket jDWPPacket = __packet;
        synchronized (jDWPPacket) {
            __packet.writeByte(JDWPHostUtils.classType((JDWPHostController)this, (Object)__object).id);
            __packet.writeId(System.identityHashCode(__object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(JDWPPacket __packet, Object __val, JDWPValueTag __context, boolean __untag) throws JDWPException {
        if (__val instanceof JDWPHostValue) {
            this.writeValue(__packet, ((JDWPHostValue)__val).get(), __context, __untag);
            return;
        }
        JDWPPacket jDWPPacket = __packet;
        synchronized (jDWPPacket) {
            switch (__context) {
                case VOID: {
                    __packet.writeByte(86);
                    break;
                }
                case BOOLEAN: {
                    if (!__untag) {
                        __packet.writeByte(90);
                    }
                    __packet.writeBoolean(__val instanceof Boolean ? (Boolean)__val : ((Number)__val).longValue() != 0L);
                    break;
                }
                case BYTE: {
                    if (!__untag) {
                        __packet.writeByte(66);
                    }
                    __packet.writeByte(((Number)__val).byteValue());
                    break;
                }
                case SHORT: {
                    if (!__untag) {
                        __packet.writeByte(83);
                    }
                    __packet.writeShort(((Number)__val).shortValue());
                    break;
                }
                case CHARACTER: {
                    if (!__untag) {
                        __packet.writeByte(67);
                    }
                    __packet.writeShort(__val instanceof Character ? ((Character)__val).charValue() : ((Number)__val).shortValue());
                    break;
                }
                case INTEGER: {
                    if (!__untag) {
                        __packet.writeByte(73);
                    }
                    __packet.writeInt(((Number)__val).intValue());
                    break;
                }
                case LONG: {
                    if (!__untag) {
                        __packet.writeByte(74);
                    }
                    __packet.writeLong(((Number)__val).longValue());
                    break;
                }
                case FLOAT: {
                    if (!__untag) {
                        __packet.writeByte(70);
                    }
                    __packet.writeInt(Float.floatToRawIntBits(((Number)__val).floatValue()));
                    break;
                }
                case DOUBLE: {
                    if (!__untag) {
                        __packet.writeByte(68);
                    }
                    __packet.writeLong(Double.doubleToRawLongBits(((Number)__val).doubleValue()));
                    break;
                }
                case ARRAY: 
                case CLASS_OBJECT: 
                case CLASS_LOADER: 
                case THREAD: 
                case THREAD_GROUP: 
                case STRING: 
                case OBJECT: {
                    switch (__context) {
                        case ARRAY: {
                            __packet.writeByte(91);
                            break;
                        }
                        case CLASS_OBJECT: {
                            __packet.writeByte(99);
                            break;
                        }
                        case CLASS_LOADER: {
                            __packet.writeByte(108);
                            break;
                        }
                        case THREAD: {
                            __packet.writeByte(116);
                            break;
                        }
                        case THREAD_GROUP: {
                            __packet.writeByte(103);
                            break;
                        }
                        case STRING: {
                            __packet.writeByte(115);
                            break;
                        }
                        default: {
                            __packet.writeByte(76);
                        }
                    }
                    this.writeObject(__packet, __val);
                    break;
                }
                default: {
                    throw Debugging.oops(new Object[]{__context});
                }
            }
        }
    }

    static {
        LinkedHashMap<JDWPCommand, JDWPCommandHandler> handlers = new LinkedHashMap<JDWPCommand, JDWPCommandHandler>();
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetArrayReference.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetClassLoader.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetClassObjectReference.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetClassType.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetEventRequest.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetMethod.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetObjectReference.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetReferenceType.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetStackFrame.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetStringReference.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetThreadGroupReference.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetThreadReference.values());
        JDWPHostController.__fillIn(handlers, JDWPHostCommandSetVirtualMachine.values());
        _HANDLERS = UnmodifiableMap.of(handlers);
    }
}

