/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPClassStatus;
import cc.squirreljme.jdwp.JDWPEventModifierContext;
import cc.squirreljme.jdwp.JDWPEventModifierKind;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPHasId;
import cc.squirreljme.jdwp.JDWPIdMap;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPValueTag;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostEventHandler;
import cc.squirreljme.jdwp.host.JDWPHostLinker;
import cc.squirreljme.jdwp.host.JDWPHostLocation;
import cc.squirreljme.jdwp.host.JDWPHostValue;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.util.Arrays;
import java.util.List;
import net.multiphasicapps.classfile.ExceptionHandler;
import net.multiphasicapps.collections.EmptyList;
import net.multiphasicapps.collections.UnmodifiableIterable;
import net.multiphasicapps.collections.UnmodifiableList;

public enum JDWPHostEventKindHandler implements JDWPHasId,
JDWPHostEventHandler
{
    SINGLE_STEP(1, (Iterable)Arrays.asList(JDWPEventModifierContext.CURRENT_THREAD, JDWPEventModifierContext.CURRENT_TYPE, JDWPEventModifierContext.CURRENT_INSTANCE), (List)Arrays.asList(JDWPEventModifierContext.PARAMETER_STEPPING), new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.LOCATION_ONLY, JDWPEventModifierKind.CALL_STACK_STEPPING, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            __controller.writeObject(__packet, __thread);
            __controller.writeLocation(__packet, __controller.locationOf(__thread));
        }
    }
    ,
    BREAKPOINT(2, (Iterable)Arrays.asList(JDWPEventModifierContext.CURRENT_THREAD, JDWPEventModifierContext.CURRENT_LOCATION, JDWPEventModifierContext.CURRENT_INSTANCE), null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.LOCATION_ONLY, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            __controller.writeObject(__packet, __thread);
            __controller.writeLocation(__packet, __controller.locationOf(__thread));
        }
    }
    ,
    FRAME_POP(3, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    EXCEPTION(4, null, (List)Arrays.asList(JDWPEventModifierContext.ENSNARE_ARGUMENT, JDWPEventModifierContext.TOSSED_EXCEPTION), new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.LOCATION_ONLY, JDWPEventModifierKind.EXCEPTION_ONLY, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            Object tossing = __args[0];
            ExceptionHandler handler = (ExceptionHandler)__args[1];
            JDWPHostLocation tossLocation = __controller.locationOf(__thread);
            __controller.writeObject(__packet, __thread);
            __controller.writeLocation(__packet, tossLocation);
            __controller.writeTaggedId(__packet, tossing);
            if (handler == null) {
                __controller.writeLocation(__packet, JDWPHostLocation.BLANK);
            } else {
                __controller.writeLocation(__packet, tossLocation.withCodeIndex(handler.handlerAddress()));
            }
        }
    }
    ,
    USER_DEFINED(5, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    THREAD_START(6, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            __controller.writeObject(__packet, __args[0]);
        }
    }
    ,
    THREAD_DEATH(7, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            __controller.writeObject(__packet, __args[0]);
        }
    }
    ,
    CLASS_PREPARE(8, null, (List)Arrays.asList(JDWPEventModifierContext.PARAMETER_TYPE), new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            Object cl2 = __args[0];
            JDWPClassStatus status = (JDWPClassStatus)((Object)__args[1]);
            __controller.writeObject(__packet, __thread);
            __controller.writeTaggedId(__packet, cl2);
            __packet.writeString(__controller.viewType().signature(cl2));
            __packet.writeInt(status.bits);
        }
    }
    ,
    CLASS_UNLOAD(9, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    CLASS_LOAD(10, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    FIELD_ACCESS(20, (Iterable)Arrays.asList(JDWPEventModifierContext.CURRENT_THREAD, JDWPEventModifierContext.CURRENT_LOCATION, JDWPEventModifierContext.CURRENT_TYPE, JDWPEventModifierContext.CURRENT_INSTANCE), (List)Arrays.asList(JDWPEventModifierContext.PARAMETER_TYPE_OR_FIELD, JDWPEventModifierContext.PARAMETER_FIELD), new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.LOCATION_ONLY, JDWPEventModifierKind.FIELD_ONLY, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            this.__field(false, __controller, __thread, __packet, __args);
        }
    }
    ,
    FIELD_MODIFICATION(21, (Iterable)Arrays.asList(JDWPEventModifierContext.CURRENT_THREAD, JDWPEventModifierContext.CURRENT_LOCATION, JDWPEventModifierContext.CURRENT_TYPE, JDWPEventModifierContext.CURRENT_INSTANCE), (List)Arrays.asList(JDWPEventModifierContext.PARAMETER_TYPE_OR_FIELD, JDWPEventModifierContext.PARAMETER_FIELD), new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.LOCATION_ONLY, JDWPEventModifierKind.FIELD_ONLY, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            this.__field(true, __controller, __thread, __packet, __args);
        }
    }
    ,
    EXCEPTION_CATCH(30, null, (List)Arrays.asList(JDWPEventModifierContext.ENSNARE_ARGUMENT, JDWPEventModifierContext.TOSSED_EXCEPTION), new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.LOCATION_ONLY, JDWPEventModifierKind.EXCEPTION_ONLY, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            EXCEPTION.write(__controller, __thread, __packet, __args);
        }
    }
    ,
    METHOD_ENTRY(40, (Iterable)Arrays.asList(JDWPEventModifierContext.CURRENT_LOCATION, JDWPEventModifierContext.CURRENT_INSTANCE, JDWPEventModifierContext.CURRENT_TYPE), null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            __controller.writeObject(__packet, __thread);
            __controller.writeLocation(__packet, __controller.locationOf(__thread));
        }
    }
    ,
    METHOD_EXIT(41, (Iterable)Arrays.asList(JDWPEventModifierContext.CURRENT_LOCATION, JDWPEventModifierContext.CURRENT_INSTANCE, JDWPEventModifierContext.CURRENT_TYPE), null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            __controller.writeObject(__packet, __thread);
            __controller.writeLocation(__packet, __controller.locationOf(__thread));
        }
    }
    ,
    METHOD_EXIT_WITH_RETURN_VALUE(42, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            __controller.writeObject(__packet, __thread);
            __controller.writeLocation(__packet, __controller.locationOf(__thread));
            JDWPValueTag context = __controller.guessTypeRaw(__args[0]);
            __controller.writeValue(__packet, __args[0], context, false);
        }
    }
    ,
    MONITOR_CONTENDED_ENTER(43, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    MONITOR_CONTENDED_EXIT(44, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    MONITOR_WAIT(45, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    MONITOR_WAITED(46, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.CLASS_ONLY, JDWPEventModifierKind.CLASS_MATCH_PATTERN, JDWPEventModifierKind.CLASS_EXCLUDE_PATTERN, JDWPEventModifierKind.THIS_INSTANCE_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    VM_START(90, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.THREAD_ONLY, JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            __controller.writeObject(__packet, __thread);
        }
    }
    ,
    VM_DEATH(99, null, null, new JDWPEventModifierKind[]{JDWPEventModifierKind.LIMIT_OCCURRENCES}){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.todo();
        }
    }
    ,
    UNCONDITIONAL_BREAKPOINT(-2, null, null, new JDWPEventModifierKind[0]){

        @Override
        public void write(JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
            throw Debugging.oops();
        }
    };

    private static final JDWPIdMap<JDWPHostEventKindHandler> _QUICK;
    public final int id;
    private final int _modifierBits;
    private final Iterable<JDWPEventModifierContext> _nonArg;
    private final List<JDWPEventModifierContext> _arg;

    private JDWPHostEventKindHandler(int __id, Iterable<JDWPEventModifierContext> __nonArg, List<JDWPEventModifierContext> __arg, JDWPEventModifierKind ... __modifiers) {
        this.id = __id;
        this._nonArg = __nonArg == null ? EmptyList.empty() : UnmodifiableIterable.of(__nonArg);
        this._arg = __arg == null ? EmptyList.empty() : UnmodifiableList.of(__arg);
        int modifierBits = 0;
        for (JDWPEventModifierKind mod : __modifiers) {
            modifierBits |= 1 << mod.ordinal();
        }
        this._modifierBits = modifierBits;
    }

    public final JDWPEventModifierContext contextArgument(int __i) {
        List<JDWPEventModifierContext> arg = this._arg;
        if (__i < 0 || __i >= arg.size()) {
            return null;
        }
        return arg.get(__i);
    }

    public final Iterable<JDWPEventModifierContext> contextGeneral() {
        return this._nonArg;
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }

    public final boolean isValidModifier(JDWPEventModifierKind __mod) {
        return 0 != (this._modifierBits & 1 << __mod.ordinal());
    }

    void __field(boolean __write, JDWPHostController __controller, Object __thread, JDWPPacket __packet, Object ... __args) throws JDWPException {
        Object type = __args[0];
        int fieldDx = (Integer)__args[1];
        boolean write = (Boolean)__args[2];
        Object instance = __args[3];
        JDWPHostValue newValue = (JDWPHostValue)__args[4];
        __controller.writeObject(__packet, __thread);
        JDWPHostLocation location = __controller.locationOf(__thread);
        __controller.writeLocation(__packet, __controller.locationOf(__thread));
        JDWPHostLinker<Object> items = __controller.getState().items;
        if (__thread != null) {
            items.put(__thread);
        }
        if (location.type != null) {
            items.put(location.type);
        }
        __controller.writeTaggedId(__packet, type);
        if (type != null) {
            items.put(type);
        }
        __packet.writeId(fieldDx);
        JDWPValueTag context = __controller.guessTypeRaw(instance);
        __controller.writeValue(__packet, instance, context, false);
        if (instance != null) {
            items.put(instance);
        }
        if (__write || write) {
            String fieldSig = __controller.viewType().fieldSignature(type, fieldDx);
            JDWPValueTag tag = JDWPValueTag.fromSignature(fieldSig);
            __controller.writeValue(__packet, newValue, tag, false);
            Object itemVal = newValue.get();
            if (__controller.viewObject().isValid(itemVal)) {
                items.put(itemVal);
            }
        }
        if (JDWPHostController._DEBUG) {
            Debugging.debugNote("Field(%s#%d, %b, %s, %s) @ %s", type, fieldDx, write, instance, newValue, location);
        }
    }

    public static JDWPHostEventKindHandler of(int __id) {
        return (JDWPHostEventKindHandler)_QUICK.get(__id);
    }

    static {
        _QUICK = new JDWPIdMap((JDWPHasId[])JDWPHostEventKindHandler.values());
    }
}

