/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPEventKind;
import cc.squirreljme.jdwp.JDWPSuspendPolicy;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostEventRequest;
import cc.squirreljme.jdwp.host.event.JDWPHostEventFilter;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.EnumTypeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.multiphasicapps.collections.EmptyList;

public final class JDWPHostEventManager {
    private final Map<JDWPEventKind, List<JDWPHostEventRequest>> _eventByKind = new EnumTypeMap(JDWPEventKind.class, (Enum[])JDWPEventKind.values());
    private final Map<Integer, JDWPHostEventRequest> _eventById = new HashMap<Integer, JDWPHostEventRequest>();
    private final Map<JDWPEventKind, JDWPHostEventRequest> _unconditional = new EnumTypeMap(JDWPEventKind.class, (Enum[])JDWPEventKind.values());

    public JDWPHostEventManager() {
        this._unconditional.put(JDWPEventKind.BREAKPOINT, new JDWPHostEventRequest(0, JDWPEventKind.BREAKPOINT, JDWPSuspendPolicy.EVENT_THREAD, -1, null));
        this.addEventRequest(new JDWPHostEventRequest(0, JDWPEventKind.VM_START, JDWPSuspendPolicy.ALL, -1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventRequest(JDWPHostEventRequest __request) throws NullPointerException {
        if (__request == null) {
            throw new NullPointerException("NARG");
        }
        if (JDWPHostController._DEBUG) {
            Debugging.debugNote("JDWP: Adding event %s", __request);
        }
        Map<JDWPEventKind, List<JDWPHostEventRequest>> eventByKind = this._eventByKind;
        JDWPHostEventManager jDWPHostEventManager = this;
        synchronized (jDWPHostEventManager) {
            List<JDWPHostEventRequest> list = eventByKind.get(__request.eventKind);
            if (list == null) {
                list = new LinkedList<JDWPHostEventRequest>();
                eventByKind.put(__request.eventKind, list);
            }
            list.add(__request);
            this._eventById.put(__request.id, __request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(JDWPEventKind __kind) throws NullPointerException {
        if (__kind == null) {
            throw new NullPointerException("NARG");
        }
        List<JDWPHostEventRequest> events = this._eventByKind.get(__kind);
        if (events == null) {
            return;
        }
        JDWPHostEventRequest[] jDWPHostEventRequestArray = this;
        synchronized (this) {
            JDWPHostEventRequest[] clear = events.toArray(new JDWPHostEventRequest[events.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (JDWPHostEventRequest event : clear) {
                this.delete(event.id);
            }
            return;
        }
    }

    public void clearAll() {
        for (JDWPEventKind kind : JDWPEventKind.values()) {
            this.clear(kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int __id) throws NullPointerException {
        JDWPHostEventManager jDWPHostEventManager = this;
        synchronized (jDWPHostEventManager) {
            JDWPHostEventRequest request = this._eventById.get(__id);
            if (request != null) {
                this._eventByKind.get(request.eventKind).remove(request);
                this._eventById.remove(__id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<JDWPHostEventRequest> find(JDWPHostController __controller, Object __thread, boolean __unconditional, JDWPEventKind __kind, Object ... __args) throws NullPointerException {
        if (__controller == null || __kind == null) {
            throw new NullPointerException("NARG");
        }
        List<JDWPHostEventRequest> requests = this._eventByKind.get(__kind);
        if (requests == null) {
            if (__unconditional) {
                return this.__unconditional(__controller, __kind);
            }
            return EmptyList.empty();
        }
        LinkedList<JDWPHostEventRequest> rv = null;
        JDWPHostEventManager jDWPHostEventManager = this;
        synchronized (jDWPHostEventManager) {
            if (requests.isEmpty()) {
                if (__unconditional) {
                    return this.__unconditional(__controller, __kind);
                }
                return EmptyList.empty();
            }
            Iterator<JDWPHostEventRequest> iterator = requests.iterator();
            while (iterator.hasNext()) {
                int occurrencesLeft;
                JDWPHostEventRequest request = iterator.next();
                JDWPHostEventFilter filter = request.filter;
                if (filter != null && !filter.meets(__controller, __thread, __kind, __args)) continue;
                if (rv == null) {
                    rv = new LinkedList<JDWPHostEventRequest>();
                }
                rv.add(request);
                if ((occurrencesLeft = request._occurrencesLeft--) < 0 || request._occurrencesLeft > 0) continue;
                iterator.remove();
            }
        }
        if (__unconditional && (rv == null || rv.isEmpty())) {
            return this.__unconditional(__controller, __kind);
        }
        return rv == null ? EmptyList.empty() : rv;
    }

    private Iterable<JDWPHostEventRequest> __unconditional(JDWPHostController __controller, JDWPEventKind __kind) throws NullPointerException {
        if (__controller == null || __kind == null) {
            throw new NullPointerException("NARG");
        }
        JDWPHostEventRequest request = this._unconditional.get(__kind);
        if (request != null) {
            ArrayList<JDWPHostEventRequest> rv = new ArrayList<JDWPHostEventRequest>();
            rv.add(request);
            return rv;
        }
        return EmptyList.empty();
    }
}

