/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPHasIdKind;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPIdKind;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JDWPHostLinker<T> {
    protected final Class<T> type;
    private final Map<JDWPId, Reference<T>> _links = new LinkedHashMap<JDWPId, Reference<T>>();
    private final Set<JDWPId> _deprecatedGet = new LinkedHashSet<JDWPId>();
    private final Set<JDWPId> _deprecatedPut = new LinkedHashSet<JDWPId>();

    public JDWPHostLinker(Class<T> __type) throws NullPointerException {
        if (__type == null) {
            throw new NullPointerException("NARG");
        }
        this.type = __type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get(JDWPId __id) {
        Map<JDWPId, Reference<T>> links = this._links;
        JDWPHostLinker jDWPHostLinker = this;
        synchronized (jDWPHostLinker) {
            Reference<T> ref = links.get(__id);
            if (ref == null) {
                return null;
            }
            T rv = ref.get();
            if (rv == null) {
                links.remove(__id);
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final T get(int __id) {
        JDWPId realId = JDWPId.of(JDWPIdKind.UNKNOWN, __id);
        Set<JDWPId> deprecated = this._deprecatedGet;
        JDWPHostLinker jDWPHostLinker = this;
        synchronized (jDWPHostLinker) {
            if (!deprecated.contains(realId)) {
                Debugging.todoNote("Deprecated JDWPHostLinker.get(%d)", __id);
                deprecated.add(realId);
            }
        }
        return this.get(realId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(T __t) throws NullPointerException {
        JDWPHostLinker jDWPHostLinker;
        JDWPId id;
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        if (__t instanceof JDWPHasIdKind) {
            id = ((JDWPHasIdKind)__t).debuggerId();
        } else {
            id = JDWPId.of(JDWPIdKind.UNKNOWN, System.identityHashCode(__t));
            Set<JDWPId> deprecated = this._deprecatedPut;
            jDWPHostLinker = this;
            synchronized (jDWPHostLinker) {
                if (!deprecated.contains(id)) {
                    Debugging.todoNote("Deprecated JDWPHostLinker.put(%s) -> %s", __t, id);
                    deprecated.add(id);
                }
            }
        }
        Map<JDWPId, Reference<T>> links = this._links;
        jDWPHostLinker = this;
        synchronized (jDWPHostLinker) {
            T val2;
            Reference ref = links.get(id);
            if (ref == null || ref.get() == null) {
                ref = links.put(id, new WeakReference<T>(__t));
            }
            if (ref != null && (val2 = ref.get()) != null && val2 != __t) {
                Debugging.debugNote(String.format("Change of reference: %s -> %s", val2, __t));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int sizeEstimate() {
        JDWPHostLinker jDWPHostLinker = this;
        synchronized (jDWPHostLinker) {
            return this._links.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> values() {
        ArrayList<T> result = new ArrayList<T>(this.sizeEstimate());
        Map<JDWPId, Reference<T>> links = this._links;
        JDWPHostLinker jDWPHostLinker = this;
        synchronized (jDWPHostLinker) {
            Iterator<Map.Entry<JDWPId, Reference<T>>> it = links.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<JDWPId, Reference<T>> entry = it.next();
                Reference<T> ref = entry.getValue();
                T val2 = ref.get();
                if (val2 != null) {
                    result.add(val2);
                    continue;
                }
                it.remove();
            }
        }
        return Arrays.asList(result.toArray(new Object[result.size()]));
    }
}

