/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import java.util.Objects;

public final class JDWPHostLocation {
    public static final JDWPHostLocation BLANK = new JDWPHostLocation(null, -1, -1L, null, null);
    protected final long codeDx;
    public final int methodDx;
    public final Object type;
    protected final String name;
    protected final String descriptor;

    public JDWPHostLocation(Object __type, int __methodDx, long __codeDx, String __name, String __descriptor) {
        this.type = __type;
        this.methodDx = __methodDx;
        this.codeDx = __codeDx;
        this.name = Objects.toString(__name, "#" + __methodDx);
        this.descriptor = Objects.toString(__descriptor, "<?>");
    }

    public boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof JDWPHostLocation)) {
            return false;
        }
        JDWPHostLocation o2 = (JDWPHostLocation)__o;
        return Objects.equals(this.type, o2.type) && this.methodDx == o2.methodDx && this.codeDx == o2.codeDx;
    }

    public int hashCode() {
        long codeDx = this.codeDx;
        return System.identityHashCode(this.type) ^ ~this.methodDx ^ ((int)codeDx | (int)(codeDx >>> 32));
    }

    public boolean meets(Object __type, int __methodDx, int __codeDx) {
        return this.type == __type && this.methodDx == __methodDx && this.codeDx == (long)__codeDx;
    }

    public String toString() {
        return String.format("Location[%s.%s%s @%d", this.type, this.name, this.descriptor, this.codeDx);
    }

    public JDWPHostLocation withCodeIndex(int __newCodeDx) {
        return new JDWPHostLocation(this.type, this.methodDx, __newCodeDx, this.name, this.descriptor);
    }
}

