/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPStepDepth;
import cc.squirreljme.jdwp.JDWPStepSize;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.views.JDWPViewFrame;
import cc.squirreljme.jdwp.host.views.JDWPViewThread;

public final class JDWPHostStepTracker {
    protected final Position was = new Position();
    protected final Position now = new Position();
    volatile JDWPStepSize _stepSize;
    volatile JDWPStepDepth _stepDepth;
    private volatile boolean _inStepping;
    private volatile int _baseDepth = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        JDWPHostStepTracker jDWPHostStepTracker = this;
        synchronized (jDWPHostStepTracker) {
            this._inStepping = false;
            this._stepSize = null;
            this._stepDepth = null;
            this._baseDepth = -1;
            this.was.__set(-1, -1L, -1L);
            this.now.__set(-1, -1L, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPStepDepth depth() {
        JDWPHostStepTracker jDWPHostStepTracker = this;
        synchronized (jDWPHostStepTracker) {
            return this._stepDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inSteppingMode() {
        JDWPHostStepTracker jDWPHostStepTracker = this;
        synchronized (jDWPHostStepTracker) {
            return this._inStepping;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void steppingSet(JDWPHostController __controller, Object __thread, JDWPStepSize __size, JDWPStepDepth __depth) {
        JDWPHostStepTracker jDWPHostStepTracker = this;
        synchronized (jDWPHostStepTracker) {
            this._inStepping = true;
            JDWPStepSize oldSize = this._stepSize;
            this._stepSize = __size == null || oldSize == JDWPStepSize.MIN ? JDWPStepSize.MIN : __size;
            this._stepDepth = __depth == null ? JDWPStepDepth.INTO : __depth;
            Object[] frames = __controller.viewThread().frames(__thread);
            int numFrames = frames.length;
            Object frame = numFrames == 0 ? null : frames[0];
            this._baseDepth = numFrames;
            JDWPViewFrame viewFrame = __controller.viewFrame();
            Position was = this.was;
            was.__set(numFrames, frame == null ? -1L : viewFrame.atCodeIndex(frame), frame == null ? -1L : viewFrame.atLineIndex(frame));
            this.now.__copyFrom(was);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tick(JDWPHostController __jdwp, Object __thread) {
        JDWPHostStepTracker jDWPHostStepTracker = this;
        synchronized (jDWPHostStepTracker) {
            JDWPStepSize stepSize = this._stepSize;
            JDWPStepDepth stepDepth = this._stepDepth;
            if (stepSize == null || stepDepth == null) {
                return false;
            }
            JDWPViewThread viewThread = __jdwp.viewThread();
            JDWPViewFrame viewFrame = __jdwp.viewFrame();
            Object[] frames = viewThread.frames(__thread);
            int numFrames = frames.length;
            Object frame = numFrames == 0 ? null : frames[0];
            int baseDepth = this._baseDepth;
            if (baseDepth < 0) {
                baseDepth = numFrames;
            }
            long nowCode = frame == null ? -1L : viewFrame.atCodeIndex(frame);
            long nowLine = frame == null ? -1L : viewFrame.atLineIndex(frame);
            Position was = this.was;
            Position now = this.now;
            was.__copyFrom(now);
            now.__set(numFrames, nowCode, nowLine);
            int nowDepth = now._depth;
            switch (stepDepth) {
                case OUT: {
                    if (nowDepth < baseDepth) break;
                    return false;
                }
                case OVER: {
                    if (nowDepth == baseDepth) break;
                    return false;
                }
            }
            if (nowDepth != was._depth) {
                return true;
            }
            long wasLine = was._line;
            if (stepSize == JDWPStepSize.LINE && wasLine >= 0L && nowLine >= 0L) {
                return wasLine != nowLine;
            }
            return nowCode != was._code;
        }
    }

    public static final class Position {
        volatile int _depth = -1;
        volatile long _code = -1L;
        volatile long _line = -1L;

        void __copyFrom(Position __from) {
            this._depth = __from._depth;
            this._code = __from._code;
            this._line = __from._line;
        }

        void __set(int __numFrames, long __nowCode, long __nowLine) {
            this._depth = __numFrames;
            this._code = __nowCode;
            this._line = __nowLine;
        }
    }
}

