/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp.host;

import cc.squirreljme.jdwp.JDWPClassType;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.views.JDWPViewObject;
import cc.squirreljme.jdwp.host.views.JDWPViewThread;
import cc.squirreljme.jdwp.host.views.JDWPViewType;

public final class JDWPHostUtils {
    private static final int _INTERFACE_BIT = 512;

    private JDWPHostUtils() {
    }

    public static JDWPClassType classType(JDWPHostController __controller, Object __class) throws NullPointerException {
        if (__controller == null) {
            throw new NullPointerException("NARG");
        }
        JDWPViewType viewType = __controller.viewType();
        if (__class == null || !viewType.isValid(__class)) {
            JDWPViewObject viewObject = __controller.viewObject();
            if (__class != null && viewObject.isValid(__class)) {
                return JDWPHostUtils.classType(__controller, viewObject.type(__class));
            }
            return JDWPClassType.CLASS;
        }
        if (viewType.signature(__class).startsWith("[")) {
            return JDWPClassType.ARRAY;
        }
        int flags = viewType.flags(__class);
        if ((flags & 0x200) != 0) {
            return JDWPClassType.INTERFACE;
        }
        return JDWPClassType.CLASS;
    }

    public static int findFieldId(JDWPViewType __viewType, Object __type, String __fieldName, String __fieldDesc) throws NullPointerException {
        if (__viewType == null || __type == null || __fieldName == null || __fieldDesc == null) {
            throw new NullPointerException("NARG");
        }
        for (int fieldId : __viewType.fields(__type)) {
            if (!__fieldName.equals(__viewType.fieldName(__type, fieldId)) || !__fieldDesc.equals(__viewType.fieldSignature(__type, fieldId))) continue;
            return fieldId;
        }
        return -1;
    }

    public static boolean isVisibleThread(JDWPViewThread __view, Object __thread) {
        return !__view.isTerminated(__thread) && !__view.isDebugCallback(__thread) && __view.frames(__thread).length > 0;
    }

    public static String signatureToRuntime(String __signature) throws NullPointerException {
        if (__signature == null) {
            throw new NullPointerException("NARG");
        }
        if (!__signature.startsWith("L")) {
            return __signature;
        }
        return __signature.substring(1, __signature.length() - 1).replace('/', '.');
    }
}

