/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm;

import cc.squirreljme.jvm.mle.MathShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;

@SquirrelJMEVendorApi
public final class SoftLong {
    private SoftLong() {
    }

    @SquirrelJMEVendorApi
    public static long add(int __al, int __ah, int __bl, int __bh) {
        int ch2 = __ah + __bh;
        int cl2 = __al + __bl;
        if (cl2 + Integer.MIN_VALUE < __al + Integer.MIN_VALUE) {
            ++ch2;
        }
        return MathShelf.longPack(cl2, ch2);
    }

    @SquirrelJMEVendorApi
    public static long add(long __a, long __b) {
        return SoftLong.add(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    @SquirrelJMEVendorApi
    public static long and(int __al, int __ah, int __bl, int __bh) {
        return MathShelf.longPack(__al & __bl, __ah & __bh);
    }

    @SquirrelJMEVendorApi
    public static long and(long __a, long __b) {
        return SoftLong.add(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    @SquirrelJMEVendorApi
    public static int cmp(int __al, int __ah, int __bl, int __bh) {
        if (__ah < __bh) {
            return -1;
        }
        if (__ah > __bh) {
            return 1;
        }
        if ((__al -= Integer.MIN_VALUE) < (__bl -= Integer.MIN_VALUE)) {
            return -1;
        }
        if (__al > __bl) {
            return 1;
        }
        return 0;
    }

    @SquirrelJMEVendorApi
    public static int cmp(long __a, long __b) {
        return SoftLong.cmp(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    @SquirrelJMEVendorApi
    public static long div(int __al, int __ah, int __bl, int __bh) {
        if (__bh == 0 && __bl == 0) {
            throw new ArithmeticException();
        }
        return SoftLong.__div(false, __al, __ah, __bl, __bh);
    }

    @SquirrelJMEVendorApi
    public static long div(long __a, long __b) {
        return SoftLong.div(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    @SquirrelJMEVendorApi
    public static long mul(int __al, int __ah, int __bl, int __bh) {
        if ((__ah & __bh & Integer.MIN_VALUE) != 0) {
            __ah ^= 0xFFFFFFFF;
            if ((__al = ~__al + 1) == 0) {
                ++__ah;
            }
            __bh ^= 0xFFFFFFFF;
            if ((__bl = ~__bl + 1) == 0) {
                ++__bh;
            }
            return SoftLong.__mul(__al, __ah, __bl, __bh);
        }
        return SoftLong.__mul(__al, __ah, __bl, __bh);
    }

    @SquirrelJMEVendorApi
    public static long mul(long __a, long __b) {
        return SoftLong.mul(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    @SquirrelJMEVendorApi
    public static long neg(int __al, int __ah) {
        __ah ^= 0xFFFFFFFF;
        if ((__al = ~__al + 1) == 0) {
            ++__ah;
        }
        return MathShelf.longPack(__al, __ah);
    }

    @SquirrelJMEVendorApi
    public static long neg(long __a) {
        return SoftLong.mul(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a));
    }

    @SquirrelJMEVendorApi
    public static long or(int __al, int __ah, int __bl, int __bh) {
        return MathShelf.longPack(__al | __bl, __ah | __bh);
    }

    @SquirrelJMEVendorApi
    public static long or(long __a, long __b) {
        return SoftLong.or(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    @SquirrelJMEVendorApi
    public static long rem(int __al, int __ah, int __bl, int __bh) {
        if (__bh == 0 && __bl == 0) {
            throw new ArithmeticException();
        }
        return SoftLong.__div(true, __al, __ah, __bl, __bh);
    }

    @SquirrelJMEVendorApi
    public static long rem(long __a, long __b) {
        return SoftLong.rem(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    @SquirrelJMEVendorApi
    public static long shl(int __al, int __ah, int __s) {
        if ((__s &= 0x3F) == 0) {
            return MathShelf.longPack(__al, __ah);
        }
        if (__s >= 32) {
            return MathShelf.longPack(0, __al << __s - 32);
        }
        return MathShelf.longPack(__al << __s, __ah << __s | __al >>> 32 - __s);
    }

    @SquirrelJMEVendorApi
    public static long shl(long __a, int __s) {
        return SoftLong.shl(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), __s);
    }

    @SquirrelJMEVendorApi
    public static long shr(int __al, int __ah, int __s) {
        if ((__s &= 0x3F) == 0) {
            return MathShelf.longPack(__al, __ah);
        }
        if (__s >= 32) {
            return MathShelf.longPack(__ah >> __s - 32, (__ah & Integer.MIN_VALUE) >> 31);
        }
        return MathShelf.longPack(__ah << 32 - __s | __al >>> __s, __ah >> __s);
    }

    @SquirrelJMEVendorApi
    public static long shr(long __a, int __s) {
        return SoftLong.shr(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), __s);
    }

    @SquirrelJMEVendorApi
    public static long sub(int __al, int __ah, int __bl, int __bh) {
        __bh ^= 0xFFFFFFFF;
        if ((__bl = ~__bl + 1) == 0) {
            ++__bh;
        }
        int ch2 = __ah + __bh;
        int cl2 = __al + __bl;
        if (cl2 + Integer.MIN_VALUE < __al + Integer.MIN_VALUE) {
            ++ch2;
        }
        return MathShelf.longPack(cl2, ch2);
    }

    @SquirrelJMEVendorApi
    public static long sub(long __a, long __b) {
        return SoftLong.sub(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    @SquirrelJMEVendorApi
    public static double toDouble(int __al, int __ah) {
        throw Debugging.todo();
    }

    @SquirrelJMEVendorApi
    public static double toDouble(long __a) {
        return SoftLong.toDouble(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a));
    }

    @SquirrelJMEVendorApi
    public static float toFloat(int __al, int __ah) {
        throw Debugging.todo();
    }

    @SquirrelJMEVendorApi
    public static float toFloat(long __a) {
        return SoftLong.toFloat(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a));
    }

    @SquirrelJMEVendorApi
    public static int toInteger(int __al, int __ah) {
        return __al;
    }

    @SquirrelJMEVendorApi
    public static int toInteger(long __a) {
        return SoftLong.toInteger(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a));
    }

    @SquirrelJMEVendorApi
    public static long ushr(int __al, int __ah, int __s) {
        if ((__s &= 0x3F) == 0) {
            return MathShelf.longPack(__al, __ah);
        }
        if (__s >= 32) {
            return MathShelf.longPack(__ah >>> __s - 32, 0);
        }
        return MathShelf.longPack(__ah << 32 - __s | __al >>> __s, __ah >>> __s);
    }

    @SquirrelJMEVendorApi
    public static long ushr(long __a, int __s) {
        return SoftLong.ushr(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), __s);
    }

    @SquirrelJMEVendorApi
    public static long xor(int __al, int __ah, int __bl, int __bh) {
        return MathShelf.longPack(__al ^ __bl, __ah ^ __bh);
    }

    @SquirrelJMEVendorApi
    public static long xor(long __a, long __b) {
        return SoftLong.xor(MathShelf.longUnpackLow(__a), MathShelf.longUnpackHigh(__a), MathShelf.longUnpackLow(__b), MathShelf.longUnpackHigh(__b));
    }

    private static long __div(boolean __doRem, int __nl, int __nh, int __dl, int __dh) {
        boolean isNeg;
        if (__dl == 0 && __dh == 0) {
            throw new ArithmeticException("ZZ4z");
        }
        int ql = 0;
        int qh = 0;
        int rl = 0;
        int rh = 0;
        if (__dl == 0) {
            return 0L;
        }
        boolean negNum = (__nh & Integer.MIN_VALUE) != 0;
        boolean negDem = (__dh & Integer.MIN_VALUE) != 0;
        boolean bl2 = isNeg = negNum != negDem;
        if (negNum) {
            __nh ^= 0xFFFFFFFF;
            if ((__nl = ~__nl + 1) == 0) {
                ++__nh;
            }
        }
        if (negDem) {
            __dh ^= 0xFFFFFFFF;
            if ((__dl = ~__dl + 1) == 0) {
                ++__dh;
            }
        }
        int dlUnsigned = __dl + Integer.MIN_VALUE;
        int dhUnsigned = __dh + Integer.MIN_VALUE;
        int i2 = 63;
        int hMask = -1;
        int lMask = 0;
        while (i2 >= 0) {
            rh <<= 1;
            rl <<= 1;
            int cmp = (rh |= (rl |= (__nh & hMask | __nl & lMask) >>> i2 & 1) >>> 31) + Integer.MIN_VALUE - dhUnsigned;
            if (cmp >= 0 && (cmp > 0 || rl + Integer.MIN_VALUE >= dlUnsigned)) {
                int bh2 = ~__dh;
                int bl3 = ~__dl + 1;
                if (bl3 == 0) {
                    ++bh2;
                }
                rh += bh2;
                int cl2 = rl + bl3;
                if (cl2 + Integer.MIN_VALUE < rl + Integer.MIN_VALUE) {
                    ++rh;
                }
                rl = cl2;
                if (i2 >= 32) {
                    qh |= 1 << i2 - 32;
                } else {
                    ql |= 1 << i2;
                }
            }
            --i2;
            hMask >>>= 1;
            lMask = lMask >> 1 | Integer.MIN_VALUE;
        }
        if (__doRem) {
            return negNum ? SoftLong.neg(rl, rh) : MathShelf.longPack(rl, rh);
        }
        return isNeg ? SoftLong.neg(ql, qh) : MathShelf.longPack(ql, qh);
    }

    private static long __mul(int __al, int __ah, int __bl, int __bh) {
        int a2 = __ah >>> 16;
        int b2 = __ah & 0xFFFF;
        int c2 = __al >>> 16;
        int d2 = __al & 0xFFFF;
        int w2 = __bh >>> 16;
        int x2 = __bh & 0xFFFF;
        int y2 = __bl >>> 16;
        int z2 = __bl & 0xFFFF;
        int p2 = d2 * z2;
        int over = p2 >>> 16;
        int o2 = over + d2 * y2;
        over = o2 >>> 16;
        o2 = (o2 & 0xFFFF) + c2 * z2;
        int n2 = (over += o2 >>> 16) + d2 * x2;
        over = n2 >>> 16;
        n2 = (n2 & 0xFFFF) + c2 * y2;
        over += n2 >>> 16;
        n2 = (n2 & 0xFFFF) + b2 * z2;
        int m2 = (over += n2 >>> 16) + d2 * w2 + c2 * x2 + b2 * y2 + a2 * z2;
        return MathShelf.longPack(o2 << 16 | p2 & 0xFFFF, m2 << 16 | n2 & 0xFFFF);
    }
}

