/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm;

public final class SystemCallError {
    public static final byte NO_ERROR = 0;
    public static final byte UNSUPPORTED_SYSTEM_CALL = -1;
    public static final byte PIPE_DESCRIPTOR_INVALID = -2;
    public static final byte PIPE_DESCRIPTOR_BAD_WRITE = -3;
    public static final byte VALUE_OUT_OF_RANGE = -4;
    public static final byte NO_FRAMEBUFFER = -5;
    public static final byte PERMISSION_DENIED = -6;
    public static final byte INTERRUPTED = -7;
    public static final byte UNKNOWN = -8;
    public static final byte END_OF_FILE = -9;
    public static final byte IPC_ERROR = -10;
    public static final byte NO_SUCH_CLASS = -11;
    public static final byte NO_SUCH_THREAD = -12;
    public static final byte THREAD_HAS_CONTEXT = -13;
    public static final byte NO_SUCH_CONFIG_KEY = -14;
    public static final byte INVALID_MEMHANDLE_KIND = -15;
    public static final byte PIPE_DESCRIPTOR_BAD_FLUSH = -16;

    private SystemCallError() {
    }

    public static String toString(int __err) {
        switch (__err) {
            case 0: {
                return "NoError";
            }
            case -1: {
                return "UnsupportedSystemCall";
            }
            case -2: {
                return "PDInvalid";
            }
            case -3: {
                return "PDBadWrite";
            }
            case -4: {
                return "ValueOutOfRange";
            }
            case -5: {
                return "NoFramebuffer";
            }
            case -6: {
                return "PermissionDenied";
            }
            case -7: {
                return "Interrupted";
            }
            case -8: {
                return "Unknown";
            }
            case -9: {
                return "EndOfFile";
            }
            case -10: {
                return "IPCError";
            }
            case -11: {
                return "NoSuchClass";
            }
            case -12: {
                return "NoSuchThread";
            }
            case -13: {
                return "ThreadHasContext";
            }
            case -14: {
                return "NoSuchConfigKey";
            }
        }
        return "ERROR" + __err;
    }
}

