/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.launch;

import cc.squirreljme.jvm.launch.Library;
import cc.squirreljme.jvm.launch.__Libraries__;
import cc.squirreljme.jvm.mle.JarPackageShelf;
import cc.squirreljme.jvm.mle.TaskShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.mle.brackets.TaskBracket;
import cc.squirreljme.jvm.suite.DependencyInfo;
import cc.squirreljme.jvm.suite.EntryPoint;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

public abstract class Application {
    public static final String OVERRIDE_ENCODING = "cc.squirreljme.override.encoding";
    public static final String OVERRIDE_LOCALE = "cc.squirreljme.override.locale";
    public static final String MICROEDITION_PROFILES = "microedition.profiles";
    protected final JarPackageBracket jar;
    private final __Libraries__ _libraries;

    Application(JarPackageBracket __jar, __Libraries__ __libs) throws NullPointerException {
        if (__jar == null || __libs == null) {
            throw new NullPointerException("NARG");
        }
        this.jar = __jar;
        this._libraries = __libs;
    }

    public abstract String displayName();

    public abstract EntryPoint entryPoint();

    public abstract DependencyInfo loaderDependencies();

    public abstract String[] loaderEntryArgs();

    public abstract String loaderEntryClass();

    public final JarPackageBracket[] classPath() {
        Library[] libraries = this._libraries.matchDependencies(this.loaderDependencies(), true);
        int numLibs = libraries.length;
        JarPackageBracket[] classPath = new JarPackageBracket[numLibs + 1];
        for (int i2 = 0; i2 < numLibs; ++i2) {
            classPath[i2] = libraries[i2].jar;
        }
        classPath[numLibs] = this.jar;
        return classPath;
    }

    public final InputStream iconStream() {
        String imgRc = this.entryPoint().imageResource();
        if (imgRc != null) {
            return JarPackageShelf.openResource(this.jar, imgRc);
        }
        return null;
    }

    public boolean isNoLauncher() {
        return false;
    }

    public final TaskBracket launch() {
        String[] sysProps;
        Map<String, String> inSysProps = this.loaderSystemProperties();
        if (inSysProps == null) {
            sysProps = new String[]{};
        } else {
            sysProps = new String[inSysProps.size() << 1];
            int at2 = 0;
            for (Map.Entry<String, String> e2 : inSysProps.entrySet()) {
                sysProps[at2++] = e2.getKey();
                sysProps[at2++] = e2.getValue();
            }
        }
        return TaskShelf.start(this.classPath(), this.loaderEntryClass(), this.loaderEntryArgs(), sysProps, 2, 2);
    }

    public Map<String, String> loaderSystemProperties() {
        return null;
    }

    public final String squirrelJMEName() {
        String fromName = Objects.toString(this.displayName(), Objects.toString(this.entryPoint().name(), this.entryPoint().entryPoint()));
        StringBuilder sb = new StringBuilder(fromName.length());
        int n2 = fromName.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = fromName.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9') {
                sb.append(c2);
                continue;
            }
            if (c2 < 'A' || c2 > 'Z') continue;
            sb.append((char)(97 + (c2 - 65)));
        }
        if (sb.length() <= 0) {
            sb.append(fromName.hashCode());
        }
        return sb.toString();
    }
}

