/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.launch;

import cc.squirreljme.jvm.launch.ApplicationParserState;
import cc.squirreljme.jvm.launch.IModeApplication;
import cc.squirreljme.jvm.launch.JavaApplication;
import cc.squirreljme.jvm.launch.__AdfUtils__;
import cc.squirreljme.jvm.manifest.JavaManifest;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.jvm.suite.EntryPoint;
import cc.squirreljme.jvm.suite.EntryPoints;
import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.jvm.suite.SuiteInfo;
import cc.squirreljme.jvm.suite.SuiteUtils;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public enum ApplicationParser {
    JAVA{

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean parse(ApplicationParserState __state) throws NullPointerException {
            SuiteInfo info;
            JavaManifest man;
            if (__state == null) {
                throw new NullPointerException("NARG");
            }
            try (InputStream rc = __state.openResource("META-INF/MANIFEST.MF");){
                if (rc == null) {
                    if (Debugging.VERBOSE) {
                        Debugging.debugNote("No META-INF/MANIFEST.MF in %s...", __state.libraryPath());
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                man = new JavaManifest(rc);
                info = new SuiteInfo(man);
            }
            catch (MLECallError | InvalidSuiteException | IOException e2) {
                if (!Debugging.VERBOSE) return false;
                e2.printStackTrace();
                return false;
            }
            switch (info.type()) {
                case LIBLET: 
                case SQUIRRELJME_API: {
                    __state.register(info);
                    return false;
                }
                case MIDLET: {
                    Iterator iterator = new EntryPoints(man).iterator();
                    while (iterator.hasNext()) {
                        EntryPoint e3 = (EntryPoint)iterator.next();
                        JavaApplication app = __state.newJavaApplication(info, e3);
                        __state.addApplication(app);
                        __state.scanned(app);
                    }
                    return true;
                }
            }
            throw Debugging.oops();
        }
    }
    ,
    I_MODE{

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean parse(ApplicationParserState __state) throws NullPointerException {
            if (__state == null) {
                throw new NullPointerException("NARG");
            }
            String jarName = __state.libraryPath();
            JarPackageBracket jam = __state.findFirstSibling(jarName, ".jam", ".adf");
            if (jam == null) {
                if (!Debugging.VERBOSE) return false;
                Debugging.debugNote("No JAM found for %s.", jarName);
                return false;
            }
            LinkedHashMap<String, String> extraSysProps = new LinkedHashMap<String, String>();
            ApplicationParser.__doJaScratchPads(__state, jarName, extraSysProps);
            LinkedHashMap<String, String> adfProps = new LinkedHashMap<String, String>();
            try (InputStream jamIn = __state.openResource(jam, ApplicationParser.DATA_RESOURCE);){
                if (jamIn == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                __AdfUtils__.__parseAdfText(adfProps, jamIn);
            }
            catch (IOException e2) {
                if (!Debugging.VERBOSE) return false;
                e2.printStackTrace();
                return false;
            }
            try {
                IModeApplication app = __state.newIModeApplication(adfProps, extraSysProps);
                __state.addApplication(app);
                __state.scanned(app);
                return true;
            }
            catch (InvalidSuiteException e3) {
                if (!Debugging.VERBOSE) return false;
                e3.printStackTrace();
                return false;
            }
        }
    }
    ,
    I_MODE_JV_LITE2{

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean parse(ApplicationParserState __state) throws NullPointerException {
            if (__state == null) {
                throw new NullPointerException("NARG");
            }
            String jarName = __state.libraryPath();
            JarPackageBracket binaryAdf = __state.findFirstSibling(jarName, ".adf");
            if (binaryAdf == null) {
                if (!Debugging.VERBOSE) return false;
                Debugging.debugNote("No Binary ADF found for %s.", jarName);
                return false;
            }
            LinkedHashMap<String, String> adfProps = new LinkedHashMap<String, String>();
            try (InputStream binaryAdfIn = __state.openResource(binaryAdf, ApplicationParser.DATA_RESOURCE);){
                if (binaryAdfIn == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                __AdfUtils__.__parseAdfBinary(adfProps, binaryAdfIn);
            }
            catch (IOException e2) {
                if (!Debugging.VERBOSE) return false;
                e2.printStackTrace();
                return false;
            }
            if (!adfProps.containsKey("AppClass")) {
                return false;
            }
            LinkedHashMap<String, String> extraSysProps = new LinkedHashMap<String, String>();
            ApplicationParser.__doJaScratchPads(__state, jarName, extraSysProps);
            try {
                IModeApplication app = __state.newIModeApplication(adfProps, extraSysProps);
                __state.addApplication(app);
                __state.scanned(app);
                return true;
            }
            catch (InvalidSuiteException e3) {
                if (!Debugging.VERBOSE) return false;
                e3.printStackTrace();
                return false;
            }
        }
    };

    public static final String DATA_RESOURCE = "$DATA$";

    protected abstract boolean parse(ApplicationParserState var1) throws NullPointerException;

    static void __doJaScratchPads(ApplicationParserState __state, String __name, Map<String, String> __sysProps) throws NullPointerException {
        if (__state == null || __name == null || __sysProps == null) {
            throw new NullPointerException("NARG");
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            JarPackageBracket sp = __state.findIModeScratchPad(__name, i2);
            if (sp == null) continue;
            __sysProps.put(String.format("%s.%d", "cc.squirreljme.imode.seedscratchpad", i2), SuiteUtils.baseName(__state.libraryPath(sp)));
        }
    }
}

