/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.launch;

import cc.squirreljme.jvm.launch.Application;
import cc.squirreljme.jvm.launch.IModeApplication;
import cc.squirreljme.jvm.launch.JavaApplication;
import cc.squirreljme.jvm.launch.ScannerUtils;
import cc.squirreljme.jvm.launch.SuiteScanListener;
import cc.squirreljme.jvm.launch.VirtualJarPackageShelf;
import cc.squirreljme.jvm.launch.__Libraries__;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.suite.EntryPoint;
import cc.squirreljme.jvm.suite.SuiteInfo;
import cc.squirreljme.jvm.suite.SuiteUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public final class ApplicationParserState {
    protected final JarPackageBracket jar;
    protected final SuiteScanListener listener;
    protected final int jarDx;
    protected final int numJars;
    protected final VirtualJarPackageShelf shelf;
    private final __Libraries__ _libs;
    private final Map<String, JarPackageBracket> _nameToJar;
    private final List<Application> _result;

    public ApplicationParserState(SuiteScanListener __listener, int __numJars, __Libraries__ __libs, Map<String, JarPackageBracket> __nameToJar, List<Application> __result, int __accurateJarIndex, JarPackageBracket __jar, VirtualJarPackageShelf __shelf) throws NullPointerException {
        if (__libs == null || __nameToJar == null || __shelf == null || __result == null || __jar == null) {
            throw new NullPointerException("NARG");
        }
        this.jar = __jar;
        this.listener = __listener;
        this.jarDx = __accurateJarIndex;
        this.numJars = __numJars;
        this.shelf = __shelf;
        this._nameToJar = __nameToJar;
        this._libs = __libs;
        this._result = __result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplication(Application __app) throws NullPointerException {
        List<Application> result;
        if (__app == null) {
            throw new NullPointerException("NARG");
        }
        List<Application> list = result = this._result;
        synchronized (list) {
            result.add(__app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarPackageBracket findFirstSibling(String __jarName, String ... __exts) throws NullPointerException {
        Map<String, JarPackageBracket> nameToJar;
        if (__jarName == null || __exts == null || __exts.length == 0) {
            throw new NullPointerException("NARG");
        }
        Map<String, JarPackageBracket> map = nameToJar = this._nameToJar;
        synchronized (map) {
            for (String ext : __exts) {
                if (ext == null) {
                    throw new NullPointerException("NARG");
                }
                JarPackageBracket maybe = SuiteUtils.findName(nameToJar, ScannerUtils.siblingByExt(__jarName, ext));
                if (maybe == null) continue;
                return maybe;
            }
        }
        return null;
    }

    public JarPackageBracket findIModeScratchPad(String __jarName) throws NullPointerException {
        if (__jarName == null) {
            throw new NullPointerException("NARG");
        }
        return this.findFirstSibling(__jarName, ".sto", ".sp", ".sp0");
    }

    public JarPackageBracket findIModeScratchPad(String __jarName, int __pad) throws NullPointerException {
        if (__jarName == null) {
            throw new NullPointerException("NARG");
        }
        if (__pad < 0) {
            throw new IllegalArgumentException("ILLA");
        }
        if (__pad == 0) {
            return this.findIModeScratchPad(__jarName);
        }
        return this.findFirstSibling(__jarName, ".sp" + __pad);
    }

    public String libraryPath() {
        return this.libraryPath(this.jar);
    }

    public String libraryPath(JarPackageBracket __jar) throws NullPointerException {
        if (__jar == null) {
            throw new NullPointerException("NARG");
        }
        return this.shelf.libraryPath(__jar);
    }

    public IModeApplication newIModeApplication(Map<String, String> __adfProps, Map<String, String> __extraSysProps) throws NullPointerException {
        if (__adfProps == null || __extraSysProps == null) {
            throw new NullPointerException("NARG");
        }
        return new IModeApplication(this.jar, this._libs, __adfProps, this.libraryPath(), __extraSysProps);
    }

    public JavaApplication newJavaApplication(SuiteInfo __info, EntryPoint __entry) throws NullPointerException {
        if (__info == null || __entry == null) {
            throw new NullPointerException("NARG");
        }
        return new JavaApplication(__info, this.jar, this._libs, __entry);
    }

    public InputStream openResource(String __rcName) throws NullPointerException {
        return this.openResource(null, __rcName);
    }

    public InputStream openResource(JarPackageBracket __inJar, String __rcName) throws NullPointerException {
        if (__rcName == null) {
            throw new NullPointerException("NARG");
        }
        return this.shelf.openResource(__inJar == null ? this.jar : __inJar, __rcName);
    }

    public void register(SuiteInfo __info) {
        this._libs.__register(__info, this.jar);
    }

    public void scanned(Application __app) throws NullPointerException {
        if (__app == null) {
            throw new NullPointerException("NARG");
        }
        SuiteScanListener listener = this.listener;
        if (listener != null) {
            listener.scanned(__app, this.jarDx, this.numJars);
        }
    }
}

