/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.launch;

import cc.squirreljme.jvm.launch.Application;
import cc.squirreljme.jvm.launch.__Libraries__;
import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.suite.APIName;
import cc.squirreljme.jvm.suite.Configuration;
import cc.squirreljme.jvm.suite.DependencyInfo;
import cc.squirreljme.jvm.suite.EntryPoint;
import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.jvm.suite.MarkedDependency;
import cc.squirreljme.jvm.suite.Profile;
import cc.squirreljme.jvm.suite.SuiteUtils;
import cc.squirreljme.runtime.cldc.SquirrelJME;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class IModeApplication
extends Application {
    @SquirrelJMEVendorApi
    public static final String VENDOR = "Keitai-DoJa";
    protected final String jarPath;
    private final Map<String, String> _adfProps;
    private final Map<String, String> _extraSysProps;

    IModeApplication(JarPackageBracket __jar, __Libraries__ __libs, Map<String, String> __adfProps, String __jarPath) throws InvalidSuiteException, NullPointerException {
        this(__jar, __libs, __adfProps, __jarPath, null);
    }

    IModeApplication(JarPackageBracket __jar, __Libraries__ __libs, Map<String, String> __adfProps, String __jarPath, Map<String, String> __sysProps) throws InvalidSuiteException, NullPointerException {
        super(__jar, __libs);
        this._adfProps = __adfProps;
        this._extraSysProps = __sysProps;
        this.jarPath = __jarPath;
        if (!__adfProps.containsKey("AppName") || !__adfProps.containsKey("AppClass")) {
            throw new InvalidSuiteException();
        }
    }

    @Override
    public String displayName() {
        String appName = this._adfProps.get("AppName");
        String appClass = this._adfProps.get("AppClass");
        if (appName != null) {
            String jarPath;
            boolean nonIso = false;
            int n2 = appName.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (appName.charAt(i2) <= '\u00ff') continue;
                nonIso = true;
                break;
            }
            if ((nonIso || appName.indexOf(65533) >= 0) && (jarPath = this.jarPath) != null) {
                return appName + " (" + SuiteUtils.baseName(jarPath) + ")";
            }
            return appName;
        }
        return appClass != null ? appClass : "Invalid i-mode Application";
    }

    @Override
    public EntryPoint entryPoint() {
        Map<String, String> adfProps = this._adfProps;
        return new EntryPoint(this.displayName(), adfProps.get("AppClass"), adfProps.get("AppIcon"), false);
    }

    public boolean isStarApplication() {
        APIName starApiName = new APIName("Star");
        for (MarkedDependency dependency : this.loaderDependencies()) {
            if (!(dependency instanceof Profile) || !starApiName.equals(((Profile)dependency).apiName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public DependencyInfo loaderDependencies() {
        String config = this.__configuration();
        String profile = this.__profile();
        return new DependencyInfo(new Configuration(config), new Profile(profile));
    }

    @Override
    public String[] loaderEntryArgs() {
        EntryPoint entry = this.entryPoint();
        String appArgs = this._adfProps.get("AppParam");
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<String, String> e2 : this.__properties().entrySet()) {
            args.add(String.format("-Xadf:%s=%s", e2.getKey(), e2.getValue()));
        }
        args.add(entry.entryPoint());
        if (appArgs != null) {
            args.addAll(Arrays.asList(StringUtils.fieldSplitAndTrim(' ', appArgs)));
        }
        return args.toArray(new String[args.size()]);
    }

    @Override
    public String loaderEntryClass() {
        if (this.isStarApplication()) {
            return "com.docomostar.__StarAppLaunch__";
        }
        return "com.nttdocomo.ui.__AppLaunch__";
    }

    @Override
    public Map<String, String> loaderSystemProperties() {
        return this.__properties();
    }

    private String __configuration() {
        Map<String, String> adfProps = this._adfProps;
        String modern = adfProps.get("ConfigurationVer");
        if (modern != null && !modern.isEmpty()) {
            return modern;
        }
        String legacy = adfProps.get("KvmVer");
        if (legacy != null && !legacy.isEmpty()) {
            return legacy;
        }
        return "CLDC-1.0";
    }

    private String __profile() {
        Map<String, String> adfProps = this._adfProps;
        String profile = adfProps.get("ProfileVer");
        if (profile != null && !profile.isEmpty()) {
            return profile;
        }
        Configuration config = new Configuration(this.__configuration());
        String scratchPad = adfProps.get("SPsize");
        String drawArea = adfProps.get("DrawArea");
        String useBrowser = adfProps.get("UseBrowser");
        String launchApp = adfProps.get("LaunchApp");
        if (adfProps.get("AppType") != null) {
            return "Star-1.0";
        }
        if (config.is("CLDC") && config.version().atLeast(1, 1)) {
            return "DoJa-4.0";
        }
        if (scratchPad != null && scratchPad.indexOf(44) > 0 || launchApp != null) {
            return "DoJa-3.0";
        }
        if (drawArea != null || useBrowser != null) {
            return "DoJa-2.0";
        }
        return "DoJa-1.0";
    }

    private Map<String, String> __properties() {
        Map<String, String> adfProps = this._adfProps;
        LinkedHashMap<String, String> rv = new LinkedHashMap<String, String>();
        Map<String, String> extraSysProps = this._extraSysProps;
        if (extraSysProps != null && !extraSysProps.isEmpty()) {
            rv.putAll(extraSysProps);
        }
        String nameProp = Objects.toString(adfProps.get("AppName"), adfProps.get("AppClass"));
        rv.put("AppName", nameProp);
        rv.put("cc.squirreljme.imode.vendor", VENDOR);
        rv.put("cc.squirreljme.override.encoding", "shift-jis");
        rv.put("cc.squirreljme.override.locale", "ja-JP");
        String profile = this.__profile();
        rv.put("microedition.profiles", profile);
        rv.put("cc.squirreljme.imode.profile", profile);
        String spSize = adfProps.get("SPsize");
        if (spSize != null && !spSize.isEmpty()) {
            rv.put("SPsize", spSize);
        }
        if (RuntimeShelf.phoneModel() == 0) {
            rv.put("microedition.platform", SquirrelJME.platform(1));
        }
        for (Map.Entry<String, String> property : adfProps.entrySet()) {
            rv.put("cc.squirreljme.imode.adf." + property.getKey(), property.getValue());
        }
        return rv;
    }
}

