/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.launch;

import cc.squirreljme.jvm.launch.Application;
import cc.squirreljme.jvm.launch.ApplicationParser;
import cc.squirreljme.jvm.launch.ApplicationParserState;
import cc.squirreljme.jvm.launch.AvailableSuites;
import cc.squirreljme.jvm.launch.DefaultJarPackageShelf;
import cc.squirreljme.jvm.launch.SuiteScanListener;
import cc.squirreljme.jvm.launch.VirtualJarPackageShelf;
import cc.squirreljme.jvm.launch.__Libraries__;
import cc.squirreljme.jvm.launch.__SuiteScannerCounter__;
import cc.squirreljme.jvm.launch.__SuiteScannerStripe__;
import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.suite.SuiteUtils;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SuiteScanner {
    protected final VirtualJarPackageShelf shelf;
    protected final boolean parallel;

    public SuiteScanner(boolean __parallel) {
        this(__parallel, new DefaultJarPackageShelf());
    }

    public SuiteScanner(boolean __parallel, VirtualJarPackageShelf __shelf) throws NullPointerException {
        if (__shelf == null) {
            throw new NullPointerException("NARG");
        }
        this.shelf = __shelf;
        this.parallel = __parallel;
    }

    public AvailableSuites scanSuites() {
        return this.scanSuites(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailableSuites scanSuites(SuiteScanListener __listener) {
        HashMap<String, JarPackageBracket> nameToJar;
        JarPackageBracket[] jars = this.shelf.libraries();
        int numJars = jars.length;
        HashMap<String, JarPackageBracket> hashMap = nameToJar = new HashMap<String, JarPackageBracket>();
        synchronized (hashMap) {
            for (JarPackageBracket jar : jars) {
                String name = this.shelf.libraryPath(jar);
                if (name == null) continue;
                nameToJar.put(name, jar);
                nameToJar.put(SuiteUtils.baseName(name), jar);
            }
        }
        __Libraries__ libs = new __Libraries__();
        LinkedList<Application> result = new LinkedList<Application>();
        int numThreads = this.parallel ? Math.max(1, (int)RuntimeShelf.vmStatistic(4)) : 1;
        __SuiteScannerCounter__ jarIndexCount = new __SuiteScannerCounter__();
        if (numThreads <= 1) {
            this.__loadStripe(__listener, jars, numJars, nameToJar, libs, result, 0, numJars, jarIndexCount);
        } else {
            __SuiteScannerCounter__ done = new __SuiteScannerCounter__();
            int baseSplitLen = Math.max(1, numJars / numThreads);
            int actualSplits = 0;
            int at2 = 0;
            int stripe = 0;
            while (at2 < numJars) {
                if (stripe != 0) {
                    ++actualSplits;
                    Thread thread = new Thread(new __SuiteScannerStripe__(done, __listener, jars, numJars, nameToJar, libs, result, at2, Math.min(numJars, at2 + baseSplitLen), jarIndexCount, this), "SquirrelJMESuiteScanStripe-" + stripe);
                    thread.start();
                }
                at2 += baseSplitLen;
                ++stripe;
            }
            this.__loadStripe(__listener, jars, numJars, nameToJar, libs, result, 0, baseSplitLen, jarIndexCount);
            while (true) {
                __SuiteScannerCounter__ __SuiteScannerCounter__2 = done;
                synchronized (__SuiteScannerCounter__2) {
                    if (done._count >= actualSplits) {
                        break;
                    }
                    try {
                        done.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        LinkedList<Application> linkedList = result;
        synchronized (linkedList) {
            return new AvailableSuites(this.shelf, libs, result.toArray(new Application[result.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __loadStripe(SuiteScanListener __listener, JarPackageBracket[] __jars, int __numJars, Map<String, JarPackageBracket> __nameToJar, __Libraries__ __libs, List<Application> __result, int __startPos, int __endPos, __SuiteScannerCounter__ __jarIndexCount) {
        int end = Math.min(__endPos, __numJars);
        for (int i2 = __startPos; i2 < end; ++i2) {
            int accurateJarIndex;
            JarPackageBracket jar = __jars[i2];
            __SuiteScannerCounter__ __SuiteScannerCounter__2 = __jarIndexCount;
            synchronized (__SuiteScannerCounter__2) {
                ++__jarIndexCount._count;
            }
            String libPath = this.shelf.libraryPath(jar);
            if (!SuiteUtils.isJar(libPath)) {
                if (__listener == null) continue;
                __listener.skipped(accurateJarIndex, __numJars);
                continue;
            }
            Debugging.debugNote("Checking %s...", libPath);
            ApplicationParserState state = new ApplicationParserState(__listener, __numJars, __libs, __nameToJar, __result, accurateJarIndex, jar, this.shelf);
            boolean foundAny = false;
            for (ApplicationParser parser : ApplicationParser.values()) {
                foundAny |= parser.parse(state);
            }
            if (foundAny || __listener == null) continue;
            __listener.skipped(accurateJarIndex, __numJars);
        }
    }
}

