/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.mle;

import cc.squirreljme.jvm.mle.JarPackageShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.IOException;
import java.io.InputStream;

@SquirrelJMEVendorApi
public class RawJarPackageBracketInputStream
extends InputStream {
    protected final JarPackageBracket jar;
    protected final int jarSize;
    private final byte[] _singleByte = new byte[1];
    private int _readPos;

    @SquirrelJMEVendorApi
    public RawJarPackageBracketInputStream(JarPackageBracket __jar) throws IOException, NullPointerException {
        this(__jar, 0);
    }

    @SquirrelJMEVendorApi
    public RawJarPackageBracketInputStream(JarPackageBracket __jar, int __offset) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__jar == null) {
            throw new NullPointerException("NARG");
        }
        int jarSize = JarPackageShelf.rawSize(__jar);
        if (jarSize < 0) {
            throw new IOException("ZZ3u " + JarPackageShelf.libraryPath(__jar));
        }
        if (__offset < 0 || __offset > jarSize) {
            throw new IndexOutOfBoundsException("ZZ4j");
        }
        this.jar = __jar;
        this.jarSize = jarSize;
        this._readPos = __offset;
    }

    @Override
    public int available() throws IOException {
        return this.jarSize - this._readPos;
    }

    @Override
    public int read() throws IOException {
        int read;
        byte[] singleByte = this._singleByte;
        do {
            if ((read = this.read(singleByte, 0, 1)) >= 0) continue;
            return -1;
        } while (read == 0);
        return singleByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int readPos = this._readPos;
        int count = JarPackageShelf.rawData(this.jar, readPos, __b, __o, __l);
        if (count < 0) {
            this._readPos = this.jarSize;
            return -1;
        }
        this._readPos = readPos + count;
        return count;
    }
}

