/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import cc.squirreljme.jvm.suite.APIName;
import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.jvm.suite.MarkedDependency;
import cc.squirreljme.jvm.suite.MarkedProvided;
import cc.squirreljme.jvm.suite.SuiteVersion;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.StringUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;

@SquirrelJMEVendorApi
public final class Configuration
implements Comparable<Configuration>,
MarkedDependency,
MarkedProvided {
    @SquirrelJMEVendorApi
    protected final APIName name;
    @SquirrelJMEVendorApi
    protected final SuiteVersion version;
    @SquirrelJMEVendorApi
    protected final boolean compact;
    private Reference<String> _string;

    @SquirrelJMEVendorApi
    public Configuration(APIName __n, SuiteVersion __v, boolean __c) throws NullPointerException {
        if (__n == null || __v == null) {
            throw new NullPointerException("NARG");
        }
        this.name = __n;
        this.version = __v;
        this.compact = __c;
    }

    @SquirrelJMEVendorApi
    public Configuration(String __n) throws NullPointerException {
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        String[] fields = StringUtils.fieldSplit('-', __n);
        int fn = fields.length;
        if (fn != 2 && fn != 3) {
            throw new InvalidSuiteException(String.format("AR02 %s", __n));
        }
        this.compact = fn > 2 && 0 == fields[2].compareToIgnoreCase("compact");
        this.name = new APIName(fields[0]);
        this.version = new SuiteVersion(fields[1]);
    }

    @Override
    public int compareTo(Configuration __o) {
        int rv = this.name.compareTo(__o.name);
        if (rv != 0) {
            return rv;
        }
        rv = this.version.compareTo(__o.version);
        if (rv != 0) {
            return rv;
        }
        boolean a2 = this.compact;
        boolean b2 = __o.compact;
        if (a2 != b2) {
            return a2 ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof Configuration)) {
            return false;
        }
        Configuration o2 = (Configuration)__o;
        return this.name.equals(o2.name) && this.version.equals(o2.version) && this.compact == o2.compact;
    }

    public int hashCode() {
        return this.name.hashCode() ^ Objects.hashCode(this.version) ^ (this.compact ? -1 : 0);
    }

    @SquirrelJMEVendorApi
    public boolean is(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        return __key.equalsIgnoreCase(this.name.toString());
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean matchesProvided(MarkedProvided __mp) throws NullPointerException {
        if (__mp == null) {
            throw new NullPointerException("NARG");
        }
        return this.equals(__mp);
    }

    @SquirrelJMEVendorApi
    public APIName name() {
        return this.name;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = "Configuration " + this.name + ":" + this.version + (this.compact ? "-compact" : "");
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    @SquirrelJMEVendorApi
    public SuiteVersion version() {
        return this.version;
    }
}

