/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import cc.squirreljme.jvm.manifest.JavaManifestAttributes;
import cc.squirreljme.jvm.suite.Configuration;
import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.jvm.suite.MarkedDependency;
import cc.squirreljme.jvm.suite.MarkedProvided;
import cc.squirreljme.jvm.suite.MatchResult;
import cc.squirreljme.jvm.suite.Profile;
import cc.squirreljme.jvm.suite.ProvidedInfo;
import cc.squirreljme.jvm.suite.SuiteDependency;
import cc.squirreljme.jvm.suite.SuiteDependencyLevel;
import cc.squirreljme.jvm.suite.SuiteDependencyType;
import cc.squirreljme.jvm.suite.SuiteInfo;
import cc.squirreljme.jvm.suite.SuiteType;
import cc.squirreljme.runtime.cldc.util.StringUtils;
import cc.squirreljme.runtime.cldc.util.UnmodifiableIterator;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class DependencyInfo
implements Iterable<MarkedDependency> {
    private final Set<MarkedDependency> _depends;
    private Reference<String> _string;

    public DependencyInfo(MarkedDependency ... __deps) {
        this(Arrays.asList(__deps == null ? new MarkedDependency[]{} : __deps));
    }

    public DependencyInfo(Collection<MarkedDependency> __deps) throws NullPointerException {
        if (__deps == null) {
            throw new NullPointerException("NARG");
        }
        LinkedHashSet<MarkedDependency> depends = new LinkedHashSet<MarkedDependency>();
        for (MarkedDependency d2 : __deps) {
            if (d2 == null) {
                throw new NullPointerException("NARG");
            }
            depends.add(d2);
        }
        this._depends = depends;
    }

    public int count() {
        return this._depends.size();
    }

    public final boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof DependencyInfo)) {
            return false;
        }
        return this._depends.equals(((DependencyInfo)__o)._depends);
    }

    public final int hashCode() {
        return this._depends.hashCode();
    }

    public final boolean isEmpty() {
        return this._depends.isEmpty();
    }

    @Override
    public Iterator<MarkedDependency> iterator() {
        return UnmodifiableIterator.of(this._depends.iterator());
    }

    public final MatchResult match(ProvidedInfo __prov) throws NullPointerException {
        if (__prov == null) {
            throw new NullPointerException("NARG");
        }
        LinkedHashSet<MarkedDependency> depends = new LinkedHashSet<MarkedDependency>(this._depends);
        LinkedHashSet<MarkedDependency> matched = new LinkedHashSet<MarkedDependency>();
        for (MarkedProvided p2 : __prov) {
            Iterator it = depends.iterator();
            while (it.hasNext()) {
                MarkedDependency d2 = (MarkedDependency)it.next();
                if (!d2.matchesProvided(p2)) continue;
                matched.add(d2);
                it.remove();
            }
        }
        return new MatchResult(new DependencyInfo(matched), new DependencyInfo(depends));
    }

    public final DependencyInfo noOptionals() {
        Set<MarkedDependency> depends = this._depends;
        if (depends.isEmpty()) {
            return this;
        }
        LinkedHashSet<MarkedDependency> instead = new LinkedHashSet<MarkedDependency>();
        for (MarkedDependency md : depends) {
            if (md.isOptional()) continue;
            instead.add(md);
        }
        if (depends.size() == instead.size()) {
            return this;
        }
        return new DependencyInfo(instead);
    }

    public final String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = "Dependencies:" + this._depends;
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public static final DependencyInfo of(SuiteInfo __info) throws InvalidSuiteException, NullPointerException {
        if (__info == null) {
            throw new NullPointerException("NARG");
        }
        LinkedHashSet<MarkedDependency> depends = new LinkedHashSet<MarkedDependency>();
        JavaManifestAttributes attr = __info.manifest().getMainAttributes();
        String value = attr.getValue("microedition-configuration");
        if (value != null) {
            if ((value = value.trim()).equals("1.0")) {
                depends.add(new Configuration("CLDC-1.0"));
            } else {
                depends.add(new Configuration(value.trim()));
            }
        }
        if ((value = attr.getValue("microedition-profile")) != null) {
            for (String s2 : StringUtils.basicSplit(" \t", value)) {
                if (s2.equals("2.0")) {
                    depends.add(new Profile("MIDP-2.0"));
                    continue;
                }
                depends.add(new Profile(s2));
            }
        }
        SuiteType type = __info.type();
        for (int i2 = 1; i2 >= 1 && (value = attr.getValue(type.dependencyKey(i2))) != null; ++i2) {
            depends.add(new SuiteDependency(value));
        }
        value = attr.getValue("midxlet-api");
        if (value != null) {
            for (String s3 : StringUtils.basicSplit(" \t", value)) {
                depends.add(new Profile(s3));
            }
        }
        if ((value = attr.getValue("midxlet-opgl")) != null && value.equalsIgnoreCase("y")) {
            depends.add(new SuiteDependency(SuiteDependencyType.PROPRIETARY, SuiteDependencyLevel.REQUIRED, "squirreljme.project@vendor-api-softbank-mexa;;"));
        }
        return new DependencyInfo(depends);
    }
}

