/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;

public final class EntryPoint
implements Comparable<EntryPoint> {
    protected final String name;
    protected final String entry;
    protected final String imageResource;
    protected final boolean isMidlet;
    private Reference<String> _string;

    public EntryPoint(String __name, String __entry, String __imgRc, boolean __mid) throws NullPointerException {
        if (__name == null || __entry == null) {
            throw new NullPointerException("NARG");
        }
        this.name = __name;
        this.entry = __entry;
        this.isMidlet = __mid;
        this.imageResource = __imgRc == null ? null : (__imgRc.startsWith("/") ? __imgRc.substring(1) : __imgRc);
    }

    @Override
    public int compareTo(EntryPoint __o) {
        boolean ma = this.isMidlet;
        boolean mb = __o.isMidlet;
        if (ma != mb) {
            if (!ma) {
                return -1;
            }
            return 1;
        }
        int rv = this.name.compareTo(__o.name);
        if (rv != 0) {
            return rv;
        }
        return this.entry.compareTo(__o.entry);
    }

    public String entryPoint() {
        return this.entry;
    }

    public boolean equals(Object __o) {
        if (!(__o instanceof EntryPoint)) {
            return false;
        }
        EntryPoint o2 = (EntryPoint)__o;
        return this.name.equals(o2.name) && this.entry.equals(o2.entry) && Objects.equals(this.imageResource, o2.imageResource) && this.isMidlet == o2.isMidlet;
    }

    public int hashCode() {
        String imageResource = this.imageResource;
        return this.name.hashCode() ^ this.entry.hashCode() ^ (this.isMidlet ? 1 : 0) ^ (imageResource == null ? 0 : imageResource.hashCode());
    }

    public String imageResource() {
        return this.imageResource;
    }

    public boolean isMidlet() {
        return this.isMidlet;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = String.format("%s (%s: %s)", this.name, this.isMidlet ? "MIDlet" : "Classic", this.entry);
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }
}

