/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.jvm.suite.MarkedProvided;
import cc.squirreljme.jvm.suite.SuiteName;
import cc.squirreljme.jvm.suite.SuiteVendor;
import cc.squirreljme.jvm.suite.SuiteVersion;
import cc.squirreljme.runtime.cldc.util.StringUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;

public final class Standard
implements Comparable<Standard>,
MarkedProvided {
    protected final SuiteName name;
    protected final SuiteVendor vendor;
    protected final SuiteVersion version;
    private Reference<String> _string;

    public Standard(SuiteName __name, SuiteVendor __vend, SuiteVersion __vers) throws NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        this.name = __name;
        this.vendor = __vend;
        this.version = __vers;
    }

    public Standard(String __s) throws InvalidSuiteException, NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        String[] splice = StringUtils.fieldSplitAndTrim(';', __s);
        if (splice.length != 3) {
            throw new InvalidSuiteException(String.format("DG04 %s", __s));
        }
        String name = splice[0];
        if (name.isEmpty()) {
            throw new InvalidSuiteException(String.format("DG05 %s", __s));
        }
        this.name = new SuiteName(name);
        String vendor = splice[1];
        this.vendor = vendor.isEmpty() ? null : new SuiteVendor(vendor);
        String version = splice[2];
        this.version = version.isEmpty() ? null : new SuiteVersion(version);
    }

    @Override
    public int compareTo(Standard __o) {
        SuiteVersion bver;
        SuiteVendor bven;
        int rv = this.name.compareTo(__o.name);
        if (rv != 0) {
            return rv;
        }
        SuiteVendor aven = this.vendor;
        if (aven == null != ((bven = __o.vendor) == null)) {
            return aven == null ? -1 : 1;
        }
        if (aven != null && (rv = aven.compareTo(bven)) != 0) {
            return rv;
        }
        SuiteVersion aver = this.version;
        if (aver == null != ((bver = __o.version) == null)) {
            return aver == null ? -1 : 1;
        }
        if (aver != null) {
            return aver.compareTo(bver);
        }
        return 0;
    }

    public boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof Standard)) {
            return false;
        }
        Standard o2 = (Standard)__o;
        return this.name.equals(o2.name) && Objects.equals(this.vendor, o2.vendor) && Objects.equals(this.version, o2.version);
    }

    public int hashCode() {
        return this.name.hashCode() ^ Objects.hashCode(this.vendor) ^ Objects.hashCode(this.version);
    }

    public SuiteName name() {
        return this.name;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = this.name + ";" + Objects.toString(this.vendor, "") + ";" + Objects.toString(this.version, "");
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public SuiteVendor vendor() {
        return this.vendor;
    }

    public SuiteVersion version() {
        return this.version;
    }
}

