/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import cc.squirreljme.jvm.suite.InternalName;
import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.jvm.suite.MarkedDependency;
import cc.squirreljme.jvm.suite.MarkedProvided;
import cc.squirreljme.jvm.suite.Standard;
import cc.squirreljme.jvm.suite.SuiteDependencyLevel;
import cc.squirreljme.jvm.suite.SuiteDependencyType;
import cc.squirreljme.jvm.suite.SuiteIdentifier;
import cc.squirreljme.jvm.suite.SuiteName;
import cc.squirreljme.jvm.suite.SuiteType;
import cc.squirreljme.jvm.suite.SuiteVendor;
import cc.squirreljme.jvm.suite.SuiteVersionRange;
import cc.squirreljme.jvm.suite.TypedSuite;
import cc.squirreljme.runtime.cldc.util.NaturalComparator;
import cc.squirreljme.runtime.cldc.util.StringUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;

public final class SuiteDependency
implements Comparable<SuiteDependency>,
MarkedDependency {
    protected final SuiteDependencyType type;
    protected final SuiteDependencyLevel level;
    protected final SuiteName name;
    protected final SuiteVendor vendor;
    protected final SuiteVersionRange version;
    private Reference<String> _string;

    public SuiteDependency(String __s) throws InvalidSuiteException, NullPointerException {
        SuiteDependencyType type;
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        int[] sc = StringUtils.multipleIndexOf(';', __s = __s.trim());
        if (sc.length != 4) {
            throw new InvalidSuiteException(String.format("AR06 %s", __s));
        }
        String intype = __s.substring(0, sc[0]).trim();
        String inlevel = __s.substring(sc[0] + 1, sc[1]).trim();
        String inname = __s.substring(sc[1] + 1, sc[2]).trim();
        String invendor = __s.substring(sc[2] + 1, sc[3]).trim();
        String inversion = __s.substring(sc[3] + 1).trim();
        this.type = type = SuiteDependencyType.of(intype);
        this.level = SuiteDependencyLevel.of(inlevel);
        SuiteName name = inname.isEmpty() ? null : new SuiteName(inname);
        this.name = name;
        SuiteVendor vendor = invendor.isEmpty() ? null : new SuiteVendor(invendor);
        this.vendor = vendor;
        SuiteVersionRange version = inversion.isEmpty() ? null : new SuiteVersionRange(inversion);
        this.version = version;
        SuiteDependency.__check(type, this.level, name, vendor, version);
    }

    public SuiteDependency(SuiteDependencyType __type, SuiteDependencyLevel __level, String __s) throws InvalidSuiteException, NullPointerException {
        if (__type == null || __level == null || __s == null) {
            throw new NullPointerException("NARG");
        }
        int[] sc = StringUtils.multipleIndexOf(';', __s = __s.trim());
        if (sc.length != 2) {
            throw new InvalidSuiteException(String.format("AR07 %s", __s));
        }
        String inname = __s.substring(0, sc[0]).trim();
        String invendor = __s.substring(sc[0] + 1, sc[1]).trim();
        String inversion = __s.substring(sc[1] + 1).trim();
        SuiteName name = inname.isEmpty() ? null : new SuiteName(inname);
        this.name = name;
        SuiteVendor vendor = invendor.isEmpty() ? null : new SuiteVendor(invendor);
        this.vendor = vendor;
        SuiteVersionRange version = inversion.isEmpty() ? null : new SuiteVersionRange(inversion);
        this.version = version;
        SuiteDependency.__check(__type, __level, name, vendor, version);
        this.type = __type;
        this.level = __level;
    }

    public SuiteDependency(SuiteDependencyType __type, SuiteDependencyLevel __level, SuiteName __name, SuiteVendor __vendor, SuiteVersionRange __version) throws InvalidSuiteException, NullPointerException {
        if (__type == null || __level == null) {
            throw new NullPointerException("NARG");
        }
        SuiteDependency.__check(__type, __level, __name, __vendor, __version);
        this.type = __type;
        this.level = __level;
        this.name = __name;
        this.vendor = __vendor;
        this.version = __version;
    }

    @Override
    public final int compareTo(SuiteDependency __d) throws NullPointerException {
        if (__d == null) {
            throw new NullPointerException("NARG");
        }
        int rv = this.type.compareTo(__d.type);
        if (rv != 0) {
            return rv;
        }
        rv = this.level.compareTo(__d.level);
        if (rv != 0) {
            return rv;
        }
        rv = Objects.compare(this.name, __d.name, NaturalComparator.instance());
        if (rv != 0) {
            return rv;
        }
        rv = Objects.compare(this.vendor, __d.vendor, NaturalComparator.instance());
        if (rv != 0) {
            return rv;
        }
        return Objects.compare(this.version, __d.version, NaturalComparator.instance());
    }

    public boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof SuiteDependency)) {
            return false;
        }
        SuiteDependency o2 = (SuiteDependency)__o;
        return this.type.equals((Object)o2.type) && this.level.equals((Object)o2.level) && Objects.equals(this.name, o2.name) && Objects.equals(this.vendor, o2.vendor) && Objects.equals(this.version, o2.version);
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.level.hashCode() ^ Objects.hashCode(this.name) ^ Objects.hashCode(this.vendor) ^ Objects.hashCode(this.version);
    }

    @Override
    public boolean isOptional() {
        return this.level.isOptional();
    }

    public boolean isRequired() {
        return this.level.isRequired();
    }

    public SuiteDependencyLevel level() {
        return this.level;
    }

    public SuiteName name() {
        return this.name;
    }

    @Override
    public boolean matchesProvided(MarkedProvided __mp) throws NullPointerException {
        if (__mp == null) {
            throw new NullPointerException("NARG");
        }
        SuiteDependencyType type = this.type;
        Class<?> mpclass = __mp.getClass();
        SuiteName name = this.name;
        SuiteVendor vendor = this.vendor;
        SuiteVersionRange version = this.version;
        switch (type) {
            case PROPRIETARY: {
                if (__mp instanceof InternalName) {
                    String myname = name.toString();
                    int dxat = myname.indexOf(64);
                    if (dxat < 0) {
                        return false;
                    }
                    if (!myname.substring(0, dxat).equals("squirreljme.project")) {
                        return false;
                    }
                    return myname.substring(dxat + 1).equals(((InternalName)__mp).name());
                }
                return false;
            }
            case LIBLET: {
                if (__mp instanceof TypedSuite) {
                    TypedSuite other = (TypedSuite)__mp;
                    SuiteIdentifier ident = other.suite();
                    if (other.type() != SuiteType.LIBLET) {
                        return false;
                    }
                    if (!name.equals(ident.name())) {
                        return false;
                    }
                    if (vendor != null && !vendor.equals(ident.vendor())) {
                        return false;
                    }
                    return version == null || version.inRange(ident.version());
                }
                return false;
            }
            case STANDARD: {
                if (__mp instanceof Standard) {
                    Standard other = (Standard)__mp;
                    if (!name.equals(other.name())) {
                        return false;
                    }
                    if (vendor != null && !vendor.equals(other.vendor())) {
                        return false;
                    }
                    return version == null || version.inRange(other.version());
                }
                return false;
            }
        }
        throw new RuntimeException(String.format("AR08 %s %s", new Object[]{type, mpclass}));
    }

    public SuiteDependency toRequired() {
        if (this.isRequired()) {
            return this;
        }
        return new SuiteDependency(this.type, SuiteDependencyLevel.REQUIRED, this.name, this.vendor, this.version);
    }

    public SuiteDependency toOptional() {
        if (this.isOptional()) {
            return this;
        }
        return new SuiteDependency(this.type, SuiteDependencyLevel.OPTIONAL, this.name, this.vendor, this.version);
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            SuiteName name = this.name;
            SuiteVendor vendor = this.vendor;
            SuiteVersionRange version = this.version;
            rv = String.format("%s;%s;%s;%s;%s", new Object[]{this.type, this.level, name == null ? "" : name, vendor == null ? "" : vendor, version == null ? "" : version});
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public SuiteDependencyType type() {
        return this.type;
    }

    public SuiteVendor vendor() {
        return this.vendor;
    }

    public SuiteVersionRange version() {
        return this.version;
    }

    private static void __check(SuiteDependencyType __type, SuiteDependencyLevel __level, SuiteName __name, SuiteVendor __vendor, SuiteVersionRange __version) throws InvalidSuiteException {
        if (__type == SuiteDependencyType.LIBLET && (__name == null || __vendor == null || __version == null)) {
            throw new InvalidSuiteException(String.format("AR09 %s %s %s %s %s", new Object[]{__type, __level, __name, __vendor, __version}));
        }
    }
}

