/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import cc.squirreljme.jvm.manifest.JavaManifest;
import cc.squirreljme.jvm.manifest.JavaManifestAttributes;
import cc.squirreljme.jvm.suite.DependencyInfo;
import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.jvm.suite.ProvidedInfo;
import cc.squirreljme.jvm.suite.SuiteIdentifier;
import cc.squirreljme.jvm.suite.SuiteName;
import cc.squirreljme.jvm.suite.SuiteType;
import cc.squirreljme.jvm.suite.SuiteVendor;
import cc.squirreljme.jvm.suite.SuiteVersion;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;

public final class SuiteInfo {
    protected final JavaManifest manifest;
    protected final SuiteType type;
    protected final SuiteName name;
    protected final SuiteVendor vendor;
    protected final SuiteVersion version;
    private Reference<DependencyInfo> _dependencies;
    private Reference<ProvidedInfo> _provided;
    private Reference<SuiteIdentifier> _suite;

    public SuiteInfo(JavaManifest __man) throws InvalidSuiteException, NullPointerException {
        SuiteVersion version;
        SuiteVendor vendor;
        SuiteName name;
        SuiteType type;
        if (__man == null) {
            throw new NullPointerException("NARG");
        }
        this.manifest = __man;
        JavaManifestAttributes attr = __man.getMainAttributes();
        this.type = type = SuiteType.ofManifest(__man);
        this.name = name = new SuiteName(Objects.requireNonNull(attr.getValue(type.nameKey()), "AR0b"));
        this.vendor = vendor = new SuiteVendor(Objects.requireNonNull(attr.getValue(type.vendorKey()), "AR0c"));
        this.version = version = new SuiteVersion(Objects.requireNonNull(attr.getValue(type.versionKey()), "AR0d"));
    }

    public final DependencyInfo dependencies() {
        DependencyInfo rv;
        Reference<DependencyInfo> ref = this._dependencies;
        if (ref == null || null == (rv = ref.get())) {
            rv = DependencyInfo.of(this);
            this._dependencies = new WeakReference<DependencyInfo>(rv);
        }
        return rv;
    }

    public final JavaManifest manifest() {
        return this.manifest;
    }

    public final SuiteName name() {
        return this.name;
    }

    public final ProvidedInfo provided() {
        ProvidedInfo rv;
        Reference<ProvidedInfo> ref = this._provided;
        if (ref == null || null == (rv = ref.get())) {
            rv = ProvidedInfo.of(this);
            this._provided = new WeakReference<ProvidedInfo>(rv);
        }
        return rv;
    }

    public final SuiteIdentifier suite() {
        SuiteIdentifier rv;
        Reference<SuiteIdentifier> ref = this._suite;
        if (ref == null || null == (rv = ref.get())) {
            rv = new SuiteIdentifier(this.name, this.vendor, this.version);
            this._suite = new WeakReference<SuiteIdentifier>(rv);
        }
        return rv;
    }

    public final SuiteType type() {
        return this.type;
    }

    public final SuiteVendor vendor() {
        return this.vendor;
    }

    public final SuiteVersion version() {
        return this.version;
    }
}

