/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import cc.squirreljme.jvm.manifest.JavaManifest;
import cc.squirreljme.jvm.manifest.JavaManifestAttributes;
import cc.squirreljme.jvm.manifest.JavaManifestKey;
import cc.squirreljme.jvm.suite.InvalidSuiteException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public enum SuiteType {
    MIDLET("MIDlet"),
    LIBLET("LIBlet"),
    SQUIRRELJME_API("X-SquirrelJME-API");

    protected final String prefix;
    private Reference<JavaManifestKey> _description;
    private Reference<JavaManifestKey> _name;
    private Reference<JavaManifestKey> _vendor;
    private Reference<JavaManifestKey> _version;

    private SuiteType(String __p) throws NullPointerException {
        if (__p == null) {
            throw new NullPointerException("NARG");
        }
        this.prefix = __p;
    }

    public JavaManifestKey dependencyKey(int __i) {
        if (__i <= 0) {
            throw new IllegalArgumentException("AR0f");
        }
        return new JavaManifestKey(this.prefix + "-Dependency-" + __i);
    }

    public JavaManifestKey descriptionKey() {
        JavaManifestKey rv;
        Reference<JavaManifestKey> ref = this._description;
        if (ref == null || null == (rv = ref.get())) {
            rv = new JavaManifestKey(this.prefix + "-Description");
            this._description = new WeakReference<JavaManifestKey>(rv);
        }
        return rv;
    }

    public JavaManifestKey nameKey() {
        JavaManifestKey rv;
        Reference<JavaManifestKey> ref = this._name;
        if (ref == null || null == (rv = ref.get())) {
            rv = new JavaManifestKey(this.prefix + "-Name");
            this._name = new WeakReference<JavaManifestKey>(rv);
        }
        return rv;
    }

    public JavaManifestKey vendorKey() {
        JavaManifestKey rv;
        Reference<JavaManifestKey> ref = this._vendor;
        if (ref == null || null == (rv = ref.get())) {
            rv = new JavaManifestKey(this.prefix + "-Vendor");
            this._vendor = new WeakReference<JavaManifestKey>(rv);
        }
        return rv;
    }

    public JavaManifestKey versionKey() {
        JavaManifestKey rv;
        Reference<JavaManifestKey> ref = this._version;
        if (ref == null || null == (rv = ref.get())) {
            rv = new JavaManifestKey(this.prefix + "-Version");
            this._version = new WeakReference<JavaManifestKey>(rv);
        }
        return rv;
    }

    public static final SuiteType ofManifest(JavaManifest __man) throws InvalidSuiteException, NullPointerException {
        if (__man == null) {
            throw new NullPointerException("NARG");
        }
        JavaManifestAttributes attr = __man.getMainAttributes();
        for (SuiteType t2 : SuiteType.values()) {
            if (!attr.definesValue(t2.nameKey())) continue;
            return t2;
        }
        throw new InvalidSuiteException("AR0g");
    }
}

