/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

@SquirrelJMEVendorApi
public final class SuiteVersion
implements Comparable<SuiteVersion> {
    @SquirrelJMEVendorApi
    public static final SuiteVersion MIN_VERSION = new SuiteVersion(0, 0, 0);
    @SquirrelJMEVendorApi
    public static final SuiteVersion MAX_VERSION = new SuiteVersion(99, 99, 99);
    @SquirrelJMEVendorApi
    protected final int major;
    @SquirrelJMEVendorApi
    protected final int minor;
    @SquirrelJMEVendorApi
    protected final int release;
    private Reference<String> _string;

    @SquirrelJMEVendorApi
    public SuiteVersion(String __v) throws InvalidSuiteException, NullPointerException {
        this(SuiteVersion.__decodeVersion(__v));
    }

    @SquirrelJMEVendorApi
    public SuiteVersion(int[] __v) throws InvalidSuiteException, NullPointerException {
        this(__v.length > 0 ? __v[0] : 0, __v.length > 1 ? __v[1] : 0, __v.length > 2 ? __v[2] : 0);
    }

    @SquirrelJMEVendorApi
    public SuiteVersion(boolean __hash, int __maj) throws InvalidSuiteException {
        this(__hash ? __maj / 10000 : __maj, __hash ? __maj / 100 % 100 : 0, __hash ? __maj % 100 : 0);
    }

    @SquirrelJMEVendorApi
    public SuiteVersion(int __maj) {
        this(__maj, 0, 0);
    }

    @SquirrelJMEVendorApi
    public SuiteVersion(int __maj, int __min) {
        this(__maj, __min, 0);
    }

    @SquirrelJMEVendorApi
    public SuiteVersion(int __maj, int __min, int __rel) throws InvalidSuiteException {
        if (__maj < 0 || __maj > 99 || __min < 0 || __min > 99 || __rel < 0 || __rel > 99) {
            throw new InvalidSuiteException(String.format("AR0i %d %d %d", __maj, __min, __rel));
        }
        this.major = __maj;
        this.minor = __min;
        this.release = __rel;
    }

    @SquirrelJMEVendorApi
    public boolean atLeast(SuiteVersion __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        return this.hashCode() >= __v.hashCode();
    }

    @SquirrelJMEVendorApi
    public boolean atLeast(int __major, int __minor) {
        return this.major > __major || this.major == __major && this.minor >= __minor;
    }

    @Override
    public int compareTo(SuiteVersion __o) {
        int amaj = this.major;
        int bmaj = __o.major;
        int rv = amaj - bmaj;
        if (rv != 0) {
            return rv;
        }
        int amin = this.minor;
        int bmin = __o.minor;
        rv = amin - bmin;
        if (rv != 0) {
            return rv;
        }
        int arel = this.release;
        int brel = __o.release;
        rv = arel - brel;
        if (rv != 0) {
            return rv;
        }
        return 0;
    }

    public boolean equals(Object __o) {
        if (!(__o instanceof SuiteVersion)) {
            return false;
        }
        SuiteVersion o2 = (SuiteVersion)__o;
        return this.major == o2.major && this.minor == o2.minor && this.release == o2.release;
    }

    public int hashCode() {
        return this.major * 10000 + this.minor * 100 + this.release;
    }

    @SquirrelJMEVendorApi
    public int major() {
        return this.major;
    }

    @SquirrelJMEVendorApi
    public int minor() {
        return this.minor;
    }

    @SquirrelJMEVendorApi
    public int release() {
        return this.release;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = this.major + "." + this.minor + "." + this.release;
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    private static int[] __decodeVersion(String __v) throws InvalidSuiteException, NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        __v = __v.trim();
        int[] rv = new int[3];
        int n2 = __v.length();
        int at2 = 0;
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 <= n2; ++i2) {
            int c2;
            int n3 = c2 = i2 == n2 ? -1 : (int)__v.charAt(i2);
            if (c2 == 46 || c2 == -1) {
                rv[at2++] = Integer.parseInt(sb.toString(), 10);
                if (c2 != -1 && at2 >= 4) {
                    throw new InvalidSuiteException(String.format("AR0j %s", __v));
                }
                sb.setLength(0);
                continue;
            }
            if (c2 >= 48 && c2 <= 57) {
                sb.append((char)c2);
                continue;
            }
            throw new InvalidSuiteException(String.format("AR0k %s %04x", __v, c2));
        }
        return rv;
    }
}

