/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jvm.suite;

import cc.squirreljme.jvm.suite.InvalidSuiteException;
import cc.squirreljme.jvm.suite.SuiteVersion;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public final class SuiteVersionRange
implements Comparable<SuiteVersionRange> {
    public static final SuiteVersionRange ANY_VERSION = new SuiteVersionRange(SuiteVersion.MIN_VERSION, SuiteVersion.MAX_VERSION);
    protected final SuiteVersion from;
    protected final SuiteVersion to;
    private Reference<String> _string;

    public SuiteVersionRange(SuiteVersion __from, SuiteVersion __to) throws NullPointerException {
        if (__from == null || __to == null) {
            throw new NullPointerException("NARG");
        }
        if (__from.compareTo(__to) <= 0) {
            this.from = __from;
            this.to = __to;
        } else {
            this.from = __to;
            this.to = __from;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SuiteVersionRange(String __s) throws InvalidSuiteException, NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        int sl = (__s = __s.trim()).length();
        if (sl <= 0) {
            throw new IllegalArgumentException("AR0l");
        }
        char lc = __s.charAt(__s.length() - 1);
        if (lc == '+') {
            this.from = new SuiteVersion(__s.substring(0, sl - 1));
            this.to = new SuiteVersion(99, 99, 99);
            return;
        } else if (lc == '*') {
            int ld = __s.lastIndexOf(46);
            if (ld < 0) {
                if (sl != 1) throw new InvalidSuiteException(String.format("AR0m %s", __s));
                this.from = new SuiteVersion(0);
                this.to = new SuiteVersion(99, 99, 99);
                return;
            } else {
                SuiteVersion ver;
                if (ld != sl - 1) {
                    throw new InvalidSuiteException(String.format("AR0n %s", __s));
                }
                this.from = ver = new SuiteVersion(__s.substring(0, sl - 2));
                int numdots = 0;
                for (int i2 = 0; i2 < sl; ++i2) {
                    if (__s.charAt(i2) != '.') continue;
                    ++numdots;
                }
                if (numdots == 1) {
                    this.to = new SuiteVersion(ver.major(), 99, 99);
                    return;
                } else {
                    if (numdots != 2) throw new InvalidSuiteException(String.format("AR0o %s", __s));
                    this.to = new SuiteVersion(ver.major(), ver.minor(), 99);
                }
            }
            return;
        } else {
            SuiteVersion ver;
            this.from = ver = new SuiteVersion(__s);
            this.to = ver;
        }
    }

    @Override
    public int compareTo(SuiteVersionRange __o) {
        int rv = this.from.compareTo(__o.from);
        if (rv != 0) {
            return rv;
        }
        return this.to.compareTo(__o.to);
    }

    public boolean equals(Object __o) {
        if (!(__o instanceof SuiteVersionRange)) {
            return false;
        }
        SuiteVersionRange o2 = (SuiteVersionRange)__o;
        return this.from.equals(o2.from) && this.to.equals(o2.to);
    }

    public SuiteVersion from() {
        return this.from;
    }

    public int hashCode() {
        return this.to.hashCode() ^ ~this.from.hashCode();
    }

    public boolean inRange(SuiteVersion __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        return __v.compareTo(this.from) >= 0 && __v.compareTo(this.to) <= 0;
    }

    public boolean inRange(SuiteVersionRange __r) throws NullPointerException {
        if (__r == null) {
            throw new NullPointerException("NARG");
        }
        throw Debugging.todo();
    }

    public SuiteVersion to() {
        return this.to;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            StringBuilder sb = new StringBuilder();
            SuiteVersion from = this.from;
            SuiteVersion to = this.to;
            int amaj = from.major();
            int amin = from.minor();
            int arel = from.release();
            int bmaj = to.major();
            int bmin = to.minor();
            int brel = to.release();
            if (amaj == 0 && amin == 0 && arel == 0 && bmaj == 99 && bmin == 99 && brel == 99) {
                sb.append('*');
            } else {
                sb.append(amaj);
                sb.append('.');
                if (amin == 0 && arel == 0 && bmin == 99 && brel == 99) {
                    sb.append('*');
                } else {
                    sb.append(amin);
                    sb.append('.');
                    if (arel == 0 && brel == 99) {
                        sb.append('*');
                    } else {
                        sb.append(arel);
                    }
                }
                if (bmaj == 99 && bmin == 99 && brel == 99) {
                    sb.append('+');
                }
            }
            rv = sb.toString();
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public static final SuiteVersionRange atMost(SuiteVersion __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        return new SuiteVersionRange(SuiteVersion.MIN_VERSION, __v);
    }

    public static final SuiteVersionRange exactly(SuiteVersion __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        return new SuiteVersionRange(__v, __v);
    }
}

