/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.debug;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.JavaOpCodeUtils;
import java.util.Objects;

@SquirrelJMEVendorApi
public final class CallTraceElement {
    @SquirrelJMEVendorApi
    protected final String className;
    @SquirrelJMEVendorApi
    protected final String methodName;
    @SquirrelJMEVendorApi
    protected final String methodType;
    @SquirrelJMEVendorApi
    protected final long address;
    @SquirrelJMEVendorApi
    protected final String file;
    @SquirrelJMEVendorApi
    protected final int line;
    @SquirrelJMEVendorApi
    protected final int byteCodeOp;
    @SquirrelJMEVendorApi
    protected final int byteCodeAddr;
    @SquirrelJMEVendorApi
    protected final int taskId;
    @SquirrelJMEVendorApi
    protected final int nativeOp;
    @SquirrelJMEVendorApi
    private int _hash;

    @SquirrelJMEVendorApi
    public CallTraceElement() {
        this(null, null, null, -1L);
    }

    @SquirrelJMEVendorApi
    public CallTraceElement(String __cl, String __mn, String __md, long __addr) {
        this(__cl, __mn, __md, __addr, null, -1);
    }

    @SquirrelJMEVendorApi
    public CallTraceElement(String __cl, String __mn, String __md, long __addr, String __file, int __line) {
        this(__cl, __mn, __md, __addr, __file, __line, -1, -1);
    }

    @SquirrelJMEVendorApi
    public CallTraceElement(String __cl, String __mn, String __md, long __addr, String __file, int __line, int __jbc, int __jpc) {
        this(__cl, __mn, __md, __addr, __file, __line, __jbc, __jpc, 0);
    }

    @SquirrelJMEVendorApi
    public CallTraceElement(String __cl, String __mn, String __md, long __addr, String __file, int __line, int __jbc, int __jpc, int __tid) {
        this(__cl, __mn, __md, __addr, __file, __line, __jbc, __jpc, __tid, -1);
    }

    @SquirrelJMEVendorApi
    public CallTraceElement(String __cl, String __mn, String __md, long __addr, String __file, int __line, int __jbc, int __jpc, int __tid, int __nOp) {
        this.className = __cl;
        this.methodName = __mn;
        this.methodType = __md;
        this.address = __addr;
        this.file = __file;
        this.line = __line;
        this.byteCodeOp = __jbc;
        this.byteCodeAddr = __jpc;
        this.taskId = __tid;
        this.nativeOp = __nOp;
    }

    @SquirrelJMEVendorApi
    public final long address() {
        return this.address;
    }

    @SquirrelJMEVendorApi
    public final int byteCodeAddress() {
        return this.byteCodeAddr;
    }

    @SquirrelJMEVendorApi
    public final int byteCodeInstruction() {
        return this.byteCodeOp & 0xFF;
    }

    @SquirrelJMEVendorApi
    public final String className() {
        return this.className;
    }

    @SquirrelJMEVendorApi
    public final boolean equals(Object __o) {
        if (__o == this) {
            return true;
        }
        if (this.hashCode() != __o.hashCode()) {
            return false;
        }
        if (!(__o instanceof CallTraceElement)) {
            return false;
        }
        CallTraceElement o2 = (CallTraceElement)__o;
        return Objects.equals(this.className, o2.className) && Objects.equals(this.methodName, o2.methodName) && Objects.equals(this.methodType, o2.methodType) && Objects.equals(this.file, o2.file) && this.address == o2.address && this.line == o2.line && this.byteCodeOp == o2.byteCodeOp && this.byteCodeAddr == o2.byteCodeAddr && this.taskId == o2.taskId && this.nativeOp == o2.nativeOp;
    }

    @SquirrelJMEVendorApi
    public final String file() {
        return this.file;
    }

    @SquirrelJMEVendorApi
    public final int hashCode() {
        int rv = this._hash;
        if (rv == 0) {
            long address = this.address;
            this._hash = rv = Objects.hashCode(this.className) ^ Objects.hashCode(this.methodName) ^ Objects.hashCode(this.methodType) ^ Objects.hashCode(this.file) ^ (int)(address >>> 32 | address) ^ ~this.line + ~this.byteCodeOp + ~this.byteCodeAddr + ~this.taskId + ~this.nativeOp;
        }
        return rv;
    }

    @SquirrelJMEVendorApi
    public final int line() {
        return this.line;
    }

    @SquirrelJMEVendorApi
    public final String methodDescriptor() {
        return this.methodType;
    }

    @SquirrelJMEVendorApi
    public final String methodName() {
        return this.methodName;
    }

    @SquirrelJMEVendorApi
    public final int nativeOp() {
        return this.nativeOp;
    }

    @SquirrelJMEVendorApi
    public final String toAtLineString() {
        boolean hasJAddr;
        String methodname = this.methodName;
        String methoddescriptor = this.methodType;
        long address = this.address;
        int line = this.line;
        int jInst = this.byteCodeOp & 0xFF;
        int jAddr = this.byteCodeAddr;
        int taskId = this.taskId;
        int nativeOp = this.nativeOp;
        StringBuilder sb = new StringBuilder();
        sb.append('.');
        sb.append(methodname == null ? "<unknown>" : methodname);
        if (methoddescriptor != null) {
            sb.append(':');
            sb.append(methoddescriptor);
        }
        if (taskId != 0) {
            sb.append(" T");
            sb.append(taskId);
        }
        if (address != Long.MIN_VALUE) {
            sb.append(" @");
            sb.append(Long.toString(address, 16).toUpperCase());
            sb.append('h');
        }
        if (nativeOp >= 0) {
            sb.append(" ^");
            sb.append(Integer.toString(nativeOp, 16).toUpperCase());
            sb.append("h/");
            sb.append(Integer.toString(nativeOp, 2).toUpperCase());
            sb.append('b');
        }
        boolean hasLine = line >= 0;
        boolean hasJInst = jInst >= 0 && jInst < 255;
        boolean bl2 = hasJAddr = jAddr >= 0;
        if (hasLine || hasJInst || hasJAddr) {
            sb.append(" (");
            boolean sp = false;
            if (sp |= hasLine) {
                sb.append(':');
                sb.append(line);
            }
            if (hasJInst || hasJAddr) {
                if (sp) {
                    sb.append(' ');
                }
                if (hasJInst) {
                    sb.append(JavaOpCodeUtils.toString(jInst));
                }
                if (hasJAddr) {
                    sb.append('@');
                    sb.append(jAddr);
                }
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @SquirrelJMEVendorApi
    public final String toClassHeaderString() {
        String classname = this.className;
        String file = this.file;
        StringBuilder sb = new StringBuilder();
        sb.append(classname == null ? "<unknown>" : classname.replace('/', '.'));
        if (file != null) {
            sb.append(" (");
            sb.append(file);
            sb.append(')');
        }
        return sb.toString();
    }

    @SquirrelJMEVendorApi
    public final String toString() {
        boolean hasjbcaddr;
        String classname = this.className;
        String methodname = this.methodName;
        String methoddescriptor = this.methodType;
        String file = this.file;
        long address = this.address;
        int line = this.line;
        int jbcinst = this.byteCodeOp & 0xFF;
        int jbcaddr = this.byteCodeAddr;
        int taskid = this.taskId;
        int nativeOp = this.nativeOp;
        StringBuilder sb = new StringBuilder();
        sb.append(classname == null ? "<unknown>" : classname);
        sb.append('.');
        sb.append(methodname == null ? "<unknown>" : methodname);
        if (methoddescriptor != null) {
            sb.append(':');
            sb.append(methoddescriptor);
        }
        if (taskid != 0) {
            sb.append(" T");
            sb.append(taskid);
        }
        if (address != Long.MIN_VALUE) {
            sb.append(" @");
            sb.append(Long.toString(address, 16).toUpperCase());
            sb.append('h');
        }
        if (nativeOp >= 0) {
            sb.append(" ^");
            sb.append(Integer.toString(nativeOp, 16).toUpperCase());
            sb.append("h/");
            sb.append(Integer.toString(nativeOp, 2).toUpperCase());
            sb.append('b');
        }
        boolean hasfile = file != null;
        boolean hasline = line >= 0;
        boolean hasjbcinst = jbcinst > 0 && jbcinst < 255;
        boolean bl2 = hasjbcaddr = jbcaddr >= 0;
        if (hasfile || hasline || hasjbcinst || hasjbcaddr) {
            sb.append(" (");
            boolean sp = false;
            if (sp |= hasfile) {
                sb.append(file);
            }
            if (sp |= hasline) {
                sb.append(':');
                sb.append(line);
            }
            if (hasjbcinst || hasjbcaddr) {
                if (sp) {
                    sb.append(' ');
                }
                if (hasjbcinst) {
                    sb.append(JavaOpCodeUtils.toString(jbcinst));
                }
                if (hasjbcaddr) {
                    sb.append('@');
                    sb.append(jbcaddr);
                }
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

