/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.debug;

import cc.squirreljme.jvm.mle.DebugShelf;
import cc.squirreljme.jvm.mle.brackets.TracePointBracket;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.CallTraceElement;
import cc.squirreljme.runtime.cldc.lang.LineEndingUtils;
import java.io.IOException;

@SquirrelJMEVendorApi
public final class CallTraceUtils {
    private CallTraceUtils() {
    }

    @SquirrelJMEVendorApi
    public static boolean printStackTrace(Appendable __out, Throwable __toss, int __indentLevel) throws NullPointerException {
        if (__out == null) {
            throw new NullPointerException("NARG");
        }
        return CallTraceUtils.printStackTrace(__out, __toss.toString(), DebugShelf.getThrowableTrace(__toss), __toss.getCause(), __toss.getSuppressed(), __indentLevel);
    }

    @SquirrelJMEVendorApi
    public static boolean printStackTrace(Appendable __out, String __message, TracePointBracket[] __trace, Throwable __cause, Throwable[] __suppressed, int __indentLevel) throws NullPointerException {
        if (__out == null) {
            throw new NullPointerException("NARG");
        }
        return CallTraceUtils.printStackTrace(__out, __message, CallTraceUtils.resolveAll(__trace), __cause, __suppressed, __indentLevel);
    }

    @SquirrelJMEVendorApi
    public static boolean printStackTrace(Appendable __out, String __message, CallTraceElement[] __trace, Throwable __cause, Throwable[] __suppressed, int __indentLevel) throws NullPointerException {
        if (__out == null) {
            throw new NullPointerException("NARG");
        }
        int lockStep = 0;
        try {
            if (__trace == null) {
                __out.append("<No stack trace>");
                return false;
            }
            CallTraceUtils.__appendIndent(__out, __indentLevel);
            __out.append("EXCEPTION ");
            ++lockStep;
            if (__message != null) {
                __out.append(__message);
            }
            LineEndingUtils.append(__out);
            int subLevel = __indentLevel + 1;
            ++lockStep;
            String lastClass = "<Unknown>";
            for (CallTraceElement current : __trace) {
                String nowClass = current.className();
                if (nowClass == null) {
                    nowClass = "<Unknown>";
                }
                if (!nowClass.equals(lastClass)) {
                    CallTraceUtils.__appendIndent(__out, subLevel);
                    __out.append(" IN ");
                    __out.append(current.toClassHeaderString());
                    LineEndingUtils.append(__out);
                    lastClass = nowClass;
                }
                CallTraceUtils.__appendIndent(__out, subLevel);
                __out.append("- ");
                __out.append(current.toAtLineString());
                LineEndingUtils.append(__out);
                ++lockStep;
            }
            ++lockStep;
            if (__cause != null) {
                CallTraceUtils.__appendIndent(__out, subLevel);
                __out.append("CAUSED BY:");
                LineEndingUtils.append(__out);
                CallTraceUtils.printStackTrace(__out, __cause, subLevel + 1);
            }
            ++lockStep;
            if (__suppressed != null) {
                for (Throwable __throwable : __suppressed) {
                    CallTraceUtils.__appendIndent(__out, subLevel);
                    __out.append("SUPPRESSED:");
                    LineEndingUtils.append(__out);
                    CallTraceUtils.printStackTrace(__out, __throwable, subLevel + 1);
                }
            }
        }
        catch (Throwable e2) {
            try {
                CallTraceUtils.__appendIndent(__out, __indentLevel);
                __out.append("FAULT IN printStackTrace()!");
                LineEndingUtils.append(__out);
            }
            catch (Throwable ignored) {
                try {
                    __out.append('%');
                    __out.append((char)(48 + lockStep));
                    __out.append('%');
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @SquirrelJMEVendorApi
    public static CallTraceElement resolve(TracePointBracket __point) throws NullPointerException {
        if (__point == null) {
            throw new NullPointerException("NARG");
        }
        return new CallTraceElement(DebugShelf.pointClass(__point), DebugShelf.pointMethodName(__point), DebugShelf.pointMethodType(__point), DebugShelf.pointAddress(__point), DebugShelf.pointFile(__point), DebugShelf.pointLine(__point), DebugShelf.pointJavaOperation(__point), DebugShelf.pointJavaAddress(__point));
    }

    @SquirrelJMEVendorApi
    public static CallTraceElement[] resolveAll(TracePointBracket[] __trace) throws NullPointerException {
        if (__trace == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __trace.length;
        CallTraceElement[] rv = new CallTraceElement[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            rv[i2] = CallTraceUtils.resolve(__trace[i2]);
        }
        return rv;
    }

    private static void __appendIndent(Appendable __out, int __indentLevel) throws IOException {
        if (__indentLevel == 0) {
            return;
        }
        __out.append(' ');
        __out.append(' ');
        for (int i2 = 0; i2 < __indentLevel; ++i2) {
            __out.append('|');
        }
    }
}

