/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.debug;

import cc.squirreljme.jvm.mle.DebugShelf;
import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.TerminalShelf;
import cc.squirreljme.jvm.mle.ThreadShelf;
import cc.squirreljme.jvm.mle.brackets.PipeBracket;
import cc.squirreljme.jvm.mle.brackets.TracePointBracket;
import cc.squirreljme.runtime.cldc.PrintVersion;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.CallTraceUtils;
import cc.squirreljme.runtime.cldc.debug.IncompleteCodeError;
import cc.squirreljme.runtime.cldc.io.NonClosedOutputStream;
import cc.squirreljme.runtime.cldc.io.PipeOutputStream;
import cc.squirreljme.runtime.cldc.lang.LineEndingUtils;
import java.io.IOException;
import java.io.PrintStream;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.Contract;

@SquirrelJMEVendorApi
public final class Debugging {
    public static boolean ENABLED = true;
    public static boolean VERBOSE = Boolean.getBoolean("cc.squirreljme.verbose");
    @SquirrelJMEVendorApi
    public static boolean NO_EXIT = Boolean.getBoolean("cc.squirreljme.noexit");
    private static final int _BYTE_LIMIT = 126;
    private static final int _TODO_EXIT_STATUS = 63;
    private static volatile boolean _tripped;

    private Debugging() {
    }

    @SquirrelJMEVendorApi
    public static void debugNote(@PrintFormat String __fmt) {
        Debugging.__format('D', 'B', __fmt, null);
    }

    @SquirrelJMEVendorApi
    public static void debugNote(@PrintFormat String __fmt, Object ... __args) {
        Debugging.__format('D', 'B', __fmt, __args);
    }

    @SquirrelJMEVendorApi
    public static void notice(@PrintFormat String __fmt) {
        Debugging.__format('\u0000', '\u0000', __fmt, null);
    }

    @SquirrelJMEVendorApi
    public static void notice(@PrintFormat String __fmt, Object ... __args) {
        Debugging.__format('\u0000', '\u0000', __fmt, __args);
    }

    @SquirrelJMEVendorApi
    public static Error oops() {
        return Debugging.todo();
    }

    @SquirrelJMEVendorApi
    @Contract(value="_ -> fail")
    public static Error oops(Object ... __args) {
        return Debugging.todo(__args);
    }

    public static void print(char __c) {
        Debugging.print(__c, '\u0000');
    }

    public static void print(char __c, char __d) {
        if (RuntimeShelf.vmType() == 1) {
            System.err.print(__c);
            if (__d > '\u0000') {
                System.err.print(__d);
            }
            if (__c == '\n' || __d == '\n') {
                System.err.flush();
            }
            return;
        }
        PipeBracket err = TerminalShelf.fromStandard(2);
        TerminalShelf.write(err, __c > '~' ? 63 : (int)__c);
        if (__d > '\u0000') {
            TerminalShelf.write(err, __d > '~' ? 63 : (int)__d);
        }
        if (__c == '\n' || __d == '\n') {
            TerminalShelf.flush(err);
        }
    }

    @SquirrelJMEVendorApi
    public static Error todo() {
        return Debugging.todo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SquirrelJMEVendorApi
    @Contract(value="_ -> fail")
    public static Error todo(Object ... __args) {
        if (_tripped) {
            Debugging.todoNote("TODO TRIPPED IN TODO HANDLER: ");
            return new IncompleteCodeError();
        }
        _tripped = true;
        boolean stackTracePrinted = false;
        try {
            Debugging.todoNote("*****************************************");
            Debugging.todoNote("INCOMPLETE CODE HAS BEEN REACHED: ");
            try {
                PrintVersion.print(System.err);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (RuntimeShelf.vmType() == 1) {
                new Throwable("INCOMPLETE CODE").printStackTrace(System.err);
            } else {
                TracePointBracket[] trace = DebugShelf.traceStack();
                CallTraceUtils.printStackTrace((Appendable)new PrintStream(new NonClosedOutputStream(PipeOutputStream.stdErr())), "INCOMPLETE CODE", trace, null, null, 0);
                ThreadShelf.setTrace("INCOMPLETE CODE", trace);
            }
            stackTracePrinted = true;
            if (__args != null) {
                Debugging.todoNote("-----------------------------------------");
                int n2 = __args.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    try {
                        Debugging.todoNote("%d: %s", i2, __args[i2]);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            Debugging.todoNote("*****************************************");
        }
        catch (Throwable t2) {
            Debugging.todoNote("THROWABLE TOSSED IN TODO HANDLER!");
            if (!stackTracePrinted) {
                Debugging.todoNote("COULD NOT PRINT STACK TRACE!");
            }
            try {
                Debugging.todoNote("THROWABLE WAS...");
                Debugging.todoNote("    CLASS: %s", t2.getClass());
                Debugging.todoNote("    MESSG: %s", t2.getMessage());
                CallTraceUtils.printStackTrace(PipeOutputStream.stdErr(), t2, 0);
            }
            catch (LinkageError error) {
                Debugging.todoNote("WAS LINKAGE ERROR?");
                try {
                    error.printStackTrace(System.err);
                }
                catch (Throwable ignored) {
                    Debugging.todoNote("COULD NOT PRINT LINK TRACE!");
                }
            }
            catch (Throwable ignored) {
                Debugging.todoNote("COULD NOT PRINT BACKUP TRACE!");
            }
        }
        finally {
            DebugShelf.breakpoint();
            try {
                if (!NO_EXIT) {
                    System.exit(63);
                }
            }
            catch (SecurityException n2) {}
        }
        throw new IncompleteCodeError();
    }

    @SquirrelJMEVendorApi
    public static void todoNote(@PrintFormat String __fmt) {
        Debugging.__format('T', 'D', __fmt, null);
    }

    @SquirrelJMEVendorApi
    public static void todoNote(@PrintFormat String __fmt, Object ... __args) {
        Debugging.__format('T', 'D', __fmt, __args);
    }

    @SquirrelJMEVendorApi
    public static <T> T todoObject(Object ... __args) {
        throw Debugging.todo(__args);
    }

    private static void __format(char __cha, char __chb, String __format, Object ... __args) {
        try {
            if (__cha != '\u0000' && __chb != '\u0000') {
                Debugging.print(__cha, __chb);
                Debugging.print(':', ' ');
            }
            boolean specifier = false;
            boolean hasArgIndex = false;
            boolean firstChar = false;
            boolean usePrefix = false;
            boolean zeroPadding = false;
            int argIndex = 0;
            int baseArg = 0;
            int width = -1;
            int argCount = __args == null ? 0 : __args.length;
            int n2 = __format.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = __format.charAt(i2);
                if (specifier) {
                    if (c2 == '-' || c2 == '+' || c2 == ' ' || c2 == ',' || c2 == '(' || c2 == '.') continue;
                    if (firstChar && c2 == '0') {
                        zeroPadding = true;
                    } else if (c2 == '#') {
                        usePrefix = true;
                    } else if (c2 >= '1' && c2 <= '9' || !firstChar && c2 == '0') {
                        if (hasArgIndex) {
                            if (width < 0) {
                                width = 0;
                            }
                            if ((width = width * 10 + (c2 - 48)) == 0) {
                                zeroPadding = true;
                                width = -1;
                            }
                        } else {
                            argIndex = argIndex * 10 + (c2 - 48);
                        }
                    } else if (!hasArgIndex && c2 == '$') {
                        hasArgIndex = true;
                    } else if (c2 == '%' || c2 == 'n') {
                        if (c2 == '%') {
                            Debugging.print('%');
                        } else {
                            Debugging.__printLine();
                        }
                        specifier = false;
                    } else {
                        Object value;
                        if (!hasArgIndex && argIndex > 0) {
                            width = argIndex;
                        }
                        int choice = hasArgIndex ? argIndex : baseArg++;
                        Object object = value = choice < 0 || choice >= argCount ? null : __args[choice];
                        if (value == null) {
                            Debugging.print('n', 'u');
                            Debugging.print('l', 'l');
                        } else {
                            String string;
                            if (c2 == 'x' || c2 == 'X') {
                                string = (usePrefix ? "0x" : "") + Long.toString(((Number)value).longValue(), 16);
                                if (c2 == 'X') {
                                    string = string.toUpperCase();
                                }
                            } else {
                                string = c2 == 'o' ? Long.toString(((Number)value).longValue(), 8) : value.toString();
                            }
                            int strLen = string.length();
                            int pad = width - strLen;
                            while (pad-- > 0) {
                                if (zeroPadding) {
                                    Debugging.print('0');
                                    continue;
                                }
                                Debugging.print(' ');
                            }
                            for (int j2 = 0; j2 < strLen; ++j2) {
                                Debugging.print(string.charAt(j2));
                            }
                        }
                        specifier = false;
                        hasArgIndex = false;
                        usePrefix = false;
                        zeroPadding = false;
                        width = -1;
                        argIndex = -1;
                    }
                    if (!firstChar) continue;
                    firstChar = false;
                    continue;
                }
                if (c2 == '%') {
                    specifier = true;
                    firstChar = true;
                    argIndex = 0;
                    continue;
                }
                Debugging.print(c2);
            }
            Debugging.__printLine();
        }
        catch (Throwable t2) {
            Debugging.print('X');
            Debugging.print('X');
            Debugging.__printLine();
        }
    }

    private static void __print(char __c) {
        Debugging.__print(__c, '\u0000');
    }

    private static void __print(char __c, char __d) {
        if (RuntimeShelf.vmType() == 1) {
            System.err.print(__c);
            if (__d > '\u0000') {
                System.err.print(__d);
            }
            System.err.flush();
            return;
        }
        PipeBracket err = TerminalShelf.fromStandard(2);
        TerminalShelf.write(err, __c > '~' ? 63 : (int)__c);
        if (__d > '\u0000') {
            TerminalShelf.write(err, __d > '~' ? 63 : (int)__d);
        }
    }

    private static void __printLine() {
        char c2;
        int lineType = RuntimeShelf.lineEnding();
        int i2 = 0;
        while ((c2 = LineEndingUtils.toChar(lineType, i2)) != '\u0000') {
            Debugging.print(c2, '\u0000');
            ++i2;
        }
    }
}

