/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.debug;

import cc.squirreljme.jvm.mle.DebugShelf;
import cc.squirreljme.jvm.mle.JarPackageShelf;
import cc.squirreljme.jvm.mle.TypeShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.mle.brackets.TracePointBracket;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.Range;

@SquirrelJMEVendorApi
public final class ErrorCode {
    @SquirrelJMEVendorApi
    public static final String PREFIX_PROPERTY = "X-SquirrelJME-PrefixCode";

    private ErrorCode() {
    }

    @Deprecated
    @SquirrelJMEVendorApi
    public static String __error__(@PrintFormat String __format, Object ... __args) {
        int subId = 0;
        if (__format.length() >= 4) {
            char a2 = __format.charAt(2);
            char b2 = __format.charAt(3);
            subId = Character.digit(a2, 36) * 36 + Character.digit(b2, 36);
        }
        return ErrorCode.__error__(subId, __args);
    }

    @SquirrelJMEVendorApi
    public static String __error__(@Range(from=-1L, to=1296L) int __idCode) {
        return ErrorCode.__error__(__idCode, (Object[])null);
    }

    @SquirrelJMEVendorApi
    public static String __error__(@Range(from=-1L, to=1296L) int __idCode, Object ... __args) {
        String __prefix = "XX";
        Class<?> throwingClass = ErrorCode.__throwingClass();
        if (throwingClass != null) {
            __prefix = ErrorCode.__locatePrefix(ErrorCode.__unComponent(throwingClass));
        }
        int n2 = __args == null ? 0 : __args.length;
        return String.format("%s%04d%s", __prefix, __idCode, n2 == 0 ? "" : ": ") + String.format(ErrorCode.__argFormat(n2), __args);
    }

    private static String __argFormat(int __len) {
        switch (__len) {
            case 0: {
                return "";
            }
            case 1: {
                return "%s";
            }
            case 2: {
                return "%s %s";
            }
            case 3: {
                return "%s %s %s";
            }
            case 4: {
                return "%s %s %s %s";
            }
            case 5: {
                return "%s %s %s %s %s";
            }
            case 6: {
                return "%s %s %s %s %s %s";
            }
            case 7: {
                return "%s %s %s %s %s %s %s";
            }
            case 8: {
                return "%s %s %s %s %s %s %s %s";
            }
            case 9: {
                return "%s %s %s %s %s %s %s %s %s";
            }
            case 10: {
                return "%s %s %s %s %s %s %s %s %s %s";
            }
            case 11: {
                return "%s %s %s %s %s %s %s %s %s %s %s";
            }
            case 12: {
                return "%s %s %s %s %s %s %s %s %s %s %s %s";
            }
        }
        StringBuilder result = new StringBuilder(3 * __len - 1);
        for (int i2 = 0; i2 < __len; ++i2) {
            if (i2 == 0) {
                result.append("%s");
                continue;
            }
            result.append(" %s");
        }
        return result.toString();
    }

    private static String __locatePrefix(Class<?> __throwingClass) {
        if (__throwingClass == null) {
            return "?N";
        }
        JarPackageBracket inJar = TypeShelf.inJar(__throwingClass);
        if (inJar == null) {
            return "?J";
        }
        int prefixCode = JarPackageShelf.prefixCode(inJar);
        if (prefixCode < 0) {
            return "?P";
        }
        StringBuilder sb = new StringBuilder(2);
        sb.append(Character.toUpperCase(Character.forDigit(prefixCode / 36, 36)));
        sb.append(Character.toUpperCase(Character.forDigit(prefixCode % 36, 36)));
        return sb.toString();
    }

    private static Class<?> __throwingClass() {
        TracePointBracket[] trace = DebugShelf.traceStack();
        String selfClassRt = ErrorCode.class.getName();
        String selfClassBn = TypeShelf.binaryName(ErrorCode.class);
        for (TracePointBracket point : trace) {
            Class<?> found;
            String atClass = DebugShelf.pointClass(point);
            if (atClass == null || selfClassRt.equals(atClass) || selfClassBn.equals(atClass) || (found = TypeShelf.findType(atClass)) == null) continue;
            return found;
        }
        return null;
    }

    private static Class<?> __unComponent(Class<?> __in) {
        if (__in == null) {
            return null;
        }
        if (TypeShelf.isArray(__in)) {
            return TypeShelf.componentRoot(__in);
        }
        return __in;
    }
}

