/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.full;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.full.OverridingPathProvider;
import cc.squirreljme.runtime.cldc.full.SystemPath;
import cc.squirreljme.runtime.cldc.full.UnixPathProvider;
import cc.squirreljme.runtime.cldc.full.WindowsPathProvider;
import java.nio.file.Path;
import java.nio.file.Paths;

@SquirrelJMEVendorApi
public abstract class SystemPathProvider {
    @SquirrelJMEVendorApi
    public abstract Path cache();

    @SquirrelJMEVendorApi
    public abstract Path config();

    @SquirrelJMEVendorApi
    public abstract Path data();

    @SquirrelJMEVendorApi
    public abstract Path state();

    @SquirrelJMEVendorApi
    public final Path of(SystemPath __path) throws NullPointerException {
        if (__path == null) {
            throw new NullPointerException("NARG");
        }
        switch (__path) {
            case CACHE: {
                return this.cache();
            }
            case CONFIG: {
                return this.config();
            }
            case DATA: {
                return this.data();
            }
            case STATE: {
                return this.state();
            }
        }
        return null;
    }

    @SquirrelJMEVendorApi
    public final Path ofFallback(SystemPath __path) throws NullPointerException {
        if (__path == null) {
            throw new NullPointerException("NARG");
        }
        Path path = this.of(__path);
        if (path != null) {
            return path;
        }
        Path userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        return userDir.resolve("squirreljme").resolve(__path.name().toLowerCase());
    }

    @SquirrelJMEVendorApi
    public static SystemPathProvider provider() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osVersion = System.getProperty("os.version").toLowerCase();
        if (osName.contains("windows") || osName.contains("reactos")) {
            return new OverridingPathProvider(new WindowsPathProvider());
        }
        return new OverridingPathProvider(new UnixPathProvider());
    }
}

