/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.full;

import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.runtime.cldc.full.SystemPathProvider;
import java.nio.file.Path;
import java.nio.file.Paths;

public class UnixPathProvider
extends SystemPathProvider {
    @Override
    public Path cache() {
        Path path = UnixPathProvider.__env("XDG_CACHE_HOME", ".cache");
        if (path != null) {
            return path.resolve("squirreljme");
        }
        return null;
    }

    @Override
    public Path config() {
        Path path = UnixPathProvider.__env("XDG_CONFIG_HOME", ".config");
        if (path != null) {
            return path.resolve("squirreljme");
        }
        return null;
    }

    @Override
    public Path data() {
        Path path = UnixPathProvider.__env("XDG_DATA_HOME", ".local/share");
        if (path != null) {
            return path.resolve("squirreljme");
        }
        return null;
    }

    @Override
    public Path state() {
        Path path = UnixPathProvider.__env("XDG_STATE_HOME", ".local/state");
        if (path != null) {
            return path.resolve("squirreljme");
        }
        return null;
    }

    private static Path __env(String __var, String __fromHome) throws NullPointerException {
        if (__var == null || __fromHome == null) {
            throw new NullPointerException("NARG");
        }
        String xdg = RuntimeShelf.systemEnv(__var);
        if (xdg != null) {
            return Paths.get(xdg, new String[0]);
        }
        String homeDir = RuntimeShelf.systemEnv("HOME");
        if (homeDir != null) {
            return Paths.get(homeDir, new String[0]).resolve(__fromHome);
        }
        return null;
    }
}

