/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.io;

import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.io.ASCIIDecoder;
import cc.squirreljme.runtime.cldc.io.ASCIIEncoder;
import cc.squirreljme.runtime.cldc.io.Decoder;
import cc.squirreljme.runtime.cldc.io.Encoder;
import cc.squirreljme.runtime.cldc.io.IBM037Decoder;
import cc.squirreljme.runtime.cldc.io.IBM037Encoder;
import cc.squirreljme.runtime.cldc.io.IBM437Decoder;
import cc.squirreljme.runtime.cldc.io.ISO885915Decoder;
import cc.squirreljme.runtime.cldc.io.ISO885915Encoder;
import cc.squirreljme.runtime.cldc.io.ISO88591Decoder;
import cc.squirreljme.runtime.cldc.io.ISO88591Encoder;
import cc.squirreljme.runtime.cldc.io.ShiftJisDecoder;
import cc.squirreljme.runtime.cldc.io.ShiftJisEncoder;
import cc.squirreljme.runtime.cldc.io.UTF8Decoder;
import cc.squirreljme.runtime.cldc.io.UTF8Encoder;
import java.io.UnsupportedEncodingException;

@SquirrelJMEVendorApi
public final class CodecFactory {
    @SquirrelJMEVendorApi
    public static final String FALLBACK_ENCODING = "utf-8";

    private CodecFactory() {
    }

    @SquirrelJMEVendorApi
    public static Decoder decoder(int __builtIn) throws UnsupportedEncodingException {
        switch (__builtIn) {
            case 2: {
                return new ASCIIDecoder();
            }
            case 3: {
                return new IBM037Decoder();
            }
            case 7: {
                return new IBM437Decoder();
            }
            case 4: {
                return new ISO88591Decoder();
            }
            case 5: {
                return new ISO885915Decoder();
            }
            case 6: {
                return new ShiftJisDecoder();
            }
            case 1: {
                return new UTF8Decoder();
            }
        }
        throw new UnsupportedEncodingException("ZZ47 " + __builtIn);
    }

    @SquirrelJMEVendorApi
    public static Decoder decoder(String __enc) throws NullPointerException, UnsupportedEncodingException {
        return CodecFactory.decoder(CodecFactory.toBuiltIn(__enc));
    }

    @SquirrelJMEVendorApi
    public static Decoder defaultDecoder() {
        try {
            return CodecFactory.decoder(RuntimeShelf.encoding());
        }
        catch (UnsupportedEncodingException e2) {
            throw new Error("ZZ02", e2);
        }
    }

    @SquirrelJMEVendorApi
    public static Encoder defaultEncoder() {
        try {
            return CodecFactory.encoder(RuntimeShelf.encoding());
        }
        catch (UnsupportedEncodingException e2) {
            throw new Error("ZZ04", e2);
        }
    }

    @SquirrelJMEVendorApi
    public static Encoder encoder(int __builtIn) throws UnsupportedEncodingException {
        switch (__builtIn) {
            case 2: {
                return new ASCIIEncoder();
            }
            case 3: {
                return new IBM037Encoder();
            }
            case 4: {
                return new ISO88591Encoder();
            }
            case 5: {
                return new ISO885915Encoder();
            }
            case 6: {
                return new ShiftJisEncoder();
            }
            case 1: {
                return new UTF8Encoder();
            }
        }
        throw new UnsupportedEncodingException("ZZ48 " + __builtIn);
    }

    @SquirrelJMEVendorApi
    public static Encoder encoder(String __enc) throws NullPointerException, UnsupportedEncodingException {
        return CodecFactory.encoder(CodecFactory.toBuiltIn(__enc));
    }

    @SquirrelJMEVendorApi
    public static int toBuiltIn(String __enc) throws UnsupportedEncodingException {
        if (__enc == null) {
            throw new NullPointerException("NARG");
        }
        switch (__enc = CodecFactory.__normalizeEncodingName(__enc)) {
            case "ascii": {
                return 2;
            }
            case "ibm037": {
                return 3;
            }
            case "ibm437": {
                return 7;
            }
            case "iso-8859-1": {
                return 4;
            }
            case "iso-8859-15": {
                return 5;
            }
            case "shift-jis": {
                return 6;
            }
            case "utf-8": {
                return 1;
            }
        }
        throw new UnsupportedEncodingException(String.format("ZZ01 %s", __enc));
    }

    @SquirrelJMEVendorApi
    public static String toString(int __builtIn) throws IllegalArgumentException {
        switch (__builtIn) {
            case 2: {
                return "ascii";
            }
            case 3: {
                return "ibm037";
            }
            case 7: {
                return "ibm437";
            }
            case 4: {
                return "iso-8859-1";
            }
            case 5: {
                return "iso-8859-15";
            }
            case 6: {
                return "shift-jis";
            }
            case 1: {
                return FALLBACK_ENCODING;
            }
        }
        throw new IllegalArgumentException("ZZ49 " + __builtIn);
    }

    private static String __normalizeEncodingName(String __n) throws NullPointerException {
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        switch (__n.toLowerCase()) {
            case "646": 
            case "ansi_x3.4-1968": 
            case "ansi_x3.4-1986": 
            case "ascii": 
            case "ascii7": 
            case "cp367": 
            case "csascii": 
            case "ibm367": 
            case "iso_646.irv:1983": 
            case "iso_646.irv:1991": 
            case "iso646-us": 
            case "iso-ir-6": 
            case "us": 
            case "us-ascii": {
                return "ascii";
            }
            case "037": 
            case "cp037": 
            case "cpibm37": 
            case "cs-ebcdic-cp-ca": 
            case "cs-ebcdic-cp-nl": 
            case "cs-ebcdic-cp-us": 
            case "cs-ebcdic-cp-wt": 
            case "csibm037": 
            case "ebcdic-cp-ca": 
            case "ebcdic-cp-nl": 
            case "ebcdic-cp-us": 
            case "ebcdic-cp-wt": 
            case "ibm037": 
            case "ibm-037": 
            case "ibm-37": {
                return "ibm037";
            }
            case "ibm437": 
            case "ibm-437": 
            case "cp437": 
            case "437": 
            case "cspc8codepage437": 
            case "oem-us": 
            case "windows-437": {
                return "ibm437";
            }
            case "819": 
            case "8859_1": 
            case "cp819": 
            case "csisolatin1": 
            case "ibm819": 
            case "ibm-819": 
            case "iso_8859_1": 
            case "iso_8859-1": 
            case "iso-8859-1": 
            case "iso8859_1": 
            case "iso8859-1": 
            case "iso_8859-1:1987": 
            case "iso-ir-100": 
            case "l1": 
            case "latin1": {
                return "iso-8859-1";
            }
            case "shift_jis": 
            case "shift_jisx0213": 
            case "shift-jis": 
            case "shift-jisx0213": 
            case "x-sjis": 
            case "sjis": 
            case "ms_kanji": 
            case "csshiftjis": {
                return "shift-jis";
            }
            case "unicode-1-1-utf-8": 
            case "utf8": 
            case "utf-8": {
                return FALLBACK_ENCODING;
            }
        }
        return __n;
    }
}

