/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class DoubleByteTable {
    private final __BTable__[] _aTable;

    private DoubleByteTable(__BTable__[] __aTable) throws IndexOutOfBoundsException, NullPointerException {
        if (__aTable == null) {
            throw new NullPointerException("NARG");
        }
        if (__aTable.length != 256) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        this._aTable = __aTable;
    }

    public int decode(byte __a, byte __b) {
        __BTable__ bTable = this._aTable[__a & 0xFF];
        if (bTable == null) {
            return -1;
        }
        return bTable.decode(__b);
    }

    public static DoubleByteTable loadTable(InputStream __in) throws IOException, NullPointerException {
        int aByte;
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        DataInputStream in = new DataInputStream(__in);
        __BTable__[] aTable = new __BTable__[256];
        while ((aByte = in.read()) >= 0) {
            int numChars = in.readUnsignedByte();
            short[] bBytes = new short[numChars];
            char[] bChars = new char[numChars];
            for (int i2 = 0; i2 < numChars; ++i2) {
                bBytes[i2] = (short)in.readUnsignedByte();
                bChars[i2] = in.readChar();
            }
            aTable[aByte] = new __BTable__(bBytes, bChars);
        }
        return new DoubleByteTable(aTable);
    }

    private static final class __BTable__ {
        private final short[] _bBytes;
        private final char[] _bChars;

        __BTable__(short[] __bBytes, char[] __bChars) throws IllegalArgumentException, NullPointerException {
            if (__bBytes == null || __bChars == null) {
                throw new NullPointerException("NARG");
            }
            if (__bBytes.length != __bChars.length) {
                throw new IllegalArgumentException("IAEE");
            }
            this._bBytes = __bBytes;
            this._bChars = __bChars;
        }

        public int decode(byte __b) {
            int index = Arrays.binarySearch(this._bBytes, (short)(__b & 0xFF));
            if (index < 0) {
                return -1;
            }
            return this._bChars[index];
        }
    }
}

