/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.io;

import cc.squirreljme.runtime.cldc.io.PrintStreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;

public class HexDumpOutputStream
extends OutputStream {
    private static final int _COLUMNS = 16;
    protected final OutputStream pipe;
    protected final Appendable dump;
    private final byte[] _queue = new byte[16];
    private volatile int _at;

    public HexDumpOutputStream(PrintStream __dump) throws NullPointerException {
        this(new PrintStreamWriter(__dump));
    }

    public HexDumpOutputStream(Appendable __dump) throws NullPointerException {
        if (__dump == null) {
            throw new NullPointerException("NARG");
        }
        this.pipe = null;
        this.dump = __dump;
    }

    public HexDumpOutputStream(OutputStream __pipe, PrintStream __dump) throws NullPointerException {
        this(__pipe, new PrintStreamWriter(__dump));
    }

    public HexDumpOutputStream(OutputStream __pipe, Appendable __dump) throws NullPointerException {
        if (__pipe == null || __dump == null) {
            throw new NullPointerException("NARG");
        }
        this.pipe = __pipe;
        this.dump = __dump;
    }

    @Override
    public void close() throws IOException {
        this.__printLine();
        OutputStream c2 = this.pipe;
        if (c2 != null) {
            c2.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.pipe.flush();
        Appendable dump = this.dump;
        if (dump instanceof OutputStream) {
            ((OutputStream)((Object)dump)).flush();
        } else if (dump instanceof Writer) {
            ((Writer)dump).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int __b) throws IOException {
        int cols = 16;
        byte b2 = (byte)__b;
        byte[] queue = this._queue;
        int at2 = this._at;
        try {
            queue[at2++] = b2;
            this._at = at2;
            OutputStream pipe = this.pipe;
            if (pipe != null) {
                pipe.write(__b);
            }
        }
        finally {
            if (at2 == cols) {
                this.__printLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __printLine() throws IOException {
        int cols = 16;
        byte[] queue = this._queue;
        int at2 = this._at;
        try {
            int i2;
            Appendable w2 = this.dump;
            for (i2 = 0; i2 < cols; ++i2) {
                if (i2 > 0) {
                    w2.append(' ');
                    if ((i2 & 3) == 0) {
                        w2.append(' ');
                    }
                }
                if (i2 >= at2) {
                    w2.append("  ");
                    continue;
                }
                int x2 = queue[i2] & 0xFF;
                w2.append(Character.forDigit(x2 >>> 4 & 0xF, 16));
                w2.append(Character.forDigit(x2 & 0xF, 16));
            }
            w2.append("  |");
            for (i2 = 0; i2 < cols && i2 < at2; ++i2) {
                char c2 = (char)(queue[i2] & 0xFF);
                if (c2 < ' ' || c2 > '~') {
                    c2 = '.';
                }
                w2.append(c2);
            }
            w2.append('|');
            w2.append('\n');
        }
        finally {
            this._at = 0;
        }
    }

    public static boolean dump(Appendable __dump, InputStream __in) throws NullPointerException {
        if (__dump == null || __in == null) {
            throw new NullPointerException("NARG");
        }
        try (HexDumpOutputStream hdos = new HexDumpOutputStream(__dump);){
            int rc;
            byte[] buf = new byte[24];
            while ((rc = __in.read(buf)) >= 0) {
                hdos.write(buf, 0, rc);
            }
        }
        catch (IOException e2) {
            return false;
        }
        return true;
    }

    public static boolean dump(Appendable __dump, byte[] __b) throws NullPointerException {
        if (__dump == null || __b == null) {
            throw new NullPointerException("NARG");
        }
        return HexDumpOutputStream.dump(__dump, __b, 0, __b.length);
    }

    public static boolean dump(Appendable __dump, byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__dump == null || __b == null) {
            throw new NullPointerException("NARG");
        }
        try (HexDumpOutputStream hdos = new HexDumpOutputStream(__dump);){
            hdos.write(__b, __o, __l);
        }
        catch (IOException e2) {
            return false;
        }
        return true;
    }
}

