/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.io;

import cc.squirreljme.jvm.mle.ObjectShelf;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class MarkableInputStream
extends InputStream {
    protected final InputStream in;
    private byte[] _singleByte = new byte[1];
    private byte[] _cache;
    private int _readLimit = -1;
    private int _readAt = -1;
    private int _writeAt = -1;
    private boolean _hitEOF;
    private boolean _isClosed;

    public MarkableInputStream(InputStream __in) throws NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        this.in = __in;
    }

    @Override
    public int available() throws IOException {
        if (this._readLimit > 0) {
            return this._writeAt - this._readAt;
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        try {
            this.in.close();
        }
        finally {
            this._cache = null;
            this._singleByte = null;
            this._readAt = -1;
            this._readLimit = -1;
            this._writeAt = -1;
        }
    }

    @Override
    public void mark(int __readLimit) {
        byte[] cache;
        if (this._isClosed) {
            return;
        }
        if (__readLimit <= 0) {
            throw new IllegalArgumentException("ZZ4h");
        }
        byte[] oldCache = cache = this._cache;
        if (cache == null || this._cache.length < __readLimit) {
            cache = cache == null ? new byte[__readLimit] : Arrays.copyOf(cache, __readLimit);
            this._cache = cache;
        }
        int oldReadLimit = this._readLimit;
        int readAt = this._readAt;
        int writeAt = this._writeAt;
        if (oldReadLimit > 0) {
            int oldLen = writeAt - readAt;
            ObjectShelf.arrayCopy(oldCache == null ? cache : oldCache, readAt, cache, 0, oldLen);
            this._writeAt = writeAt - readAt;
        }
        this._readLimit = Math.max(oldReadLimit, __readLimit);
        this._readAt = 0;
        if (writeAt < 0) {
            this._writeAt = 0;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int rc;
        if (this._isClosed) {
            throw new IOException("CLOS");
        }
        if (this._readLimit <= 0) {
            return this.in.read();
        }
        byte[] singleByte = this._singleByte;
        do {
            if ((rc = this.__read(singleByte, 0, 1)) >= 0) continue;
            return rc;
        } while (rc <= 0);
        return singleByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (this._isClosed) {
            throw new IOException("CLOS");
        }
        return this.__read(__b, __o, __l);
    }

    @Override
    public void reset() throws IOException {
        if (this._isClosed) {
            throw new IOException("CLOS");
        }
        if (this._readLimit < 0) {
            throw new IOException("ZZ4g");
        }
        this._readAt = 0;
    }

    private int __read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        InputStream in = this.in;
        int readLimit = this._readLimit;
        if (readLimit <= 0) {
            return in.read(__b, __o, __l);
        }
        byte[] cache = this._cache;
        int writeAt = this._writeAt;
        int readAt = this._readAt;
        int cacheReadLimit = writeAt - readAt;
        int cacheLeft = cache.length - writeAt;
        boolean hitEOF = this._hitEOF;
        int outAt = __o;
        int left = __l;
        if (cacheReadLimit > 0) {
            int copyLen = Math.min(cacheReadLimit, left);
            ObjectShelf.arrayCopy(cache, readAt, __b, outAt, copyLen);
            outAt += copyLen;
            readAt += copyLen;
            left -= copyLen;
        }
        while (left > 0) {
            int rc;
            if (cacheLeft <= 0) {
                cacheLeft = -1;
                readLimit = -1;
                readAt = -1;
                writeAt = -1;
                rc = in.read(__b, outAt, left);
                if (rc < 0) {
                    hitEOF = true;
                    this._hitEOF = true;
                    break;
                }
                outAt += rc;
                left -= rc;
                continue;
            }
            rc = in.read(cache, writeAt, cacheLeft);
            if (rc < 0) {
                hitEOF = true;
                this._hitEOF = true;
                break;
            }
            int copyLimit = Math.min(rc, left);
            ObjectShelf.arrayCopy(cache, readAt, __b, outAt, copyLimit);
            outAt += copyLimit;
            left -= copyLimit;
            readAt += copyLimit;
            writeAt += rc;
            cacheLeft -= rc;
        }
        this._readLimit = readLimit;
        this._readAt = readAt;
        this._writeAt = writeAt;
        int total = outAt - __o;
        return hitEOF && total <= 0 ? -1 : total;
    }
}

