/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.io;

import cc.squirreljme.jvm.mle.AtomicShelf;
import cc.squirreljme.jvm.mle.TaskShelf;
import cc.squirreljme.jvm.mle.ThreadShelf;
import cc.squirreljme.jvm.mle.brackets.TaskBracket;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public final class TaskInputStream
extends InputStream {
    protected final TaskBracket task;
    protected final int fd;

    public TaskInputStream(TaskBracket __task, int __fd) throws NullPointerException {
        if (__task == null) {
            throw new NullPointerException("NARG");
        }
        this.task = __task;
        this.fd = __fd;
    }

    @Override
    public int read() throws InterruptedIOException, IOException {
        byte[] buf = new byte[1];
        Thread self = Thread.currentThread();
        int spin = 0;
        int rc;
        while ((rc = TaskShelf.read(this.task, this.fd, buf, 0, 1)) != -1) {
            if (rc < 0) {
                throw new IOException("ZZ45 " + rc);
            }
            if (rc == 0) {
                if (self.isInterrupted()) {
                    ThreadShelf.javaThreadClearInterrupt(self);
                    throw new InterruptedIOException("ZZ4f");
                }
            } else {
                return buf[0] & 0xFF;
            }
            AtomicShelf.spinLock(spin);
            ++spin;
        }
        return -1;
    }

    @Override
    public int read(byte[] __b) throws IOException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        int rv = TaskShelf.read(this.task, this.fd, __b, 0, __b.length);
        if (rv < 0 && rv != -1) {
            throw new IOException("ZZ4c " + rv);
        }
        return rv;
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws IOException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int rv = TaskShelf.read(this.task, this.fd, __b, __o, __l);
        if (rv < 0 && rv != -1) {
            throw new IOException("ZZ4e " + rv);
        }
        return rv;
    }
}

