/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.lang;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.IntegerArray;
import cc.squirreljme.runtime.cldc.util.IntegerIntegerArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SquirrelJMEVendorApi
public final class ArrayUtils {
    public static final byte ARRAY_BOOLEAN = 1;
    public static final byte FIRST_TYPE = 1;
    public static final byte ARRAY_BYTE = 2;
    public static final byte ARRAY_SHORT = 3;
    public static final byte ARRAY_CHARACTER = 4;
    public static final byte ARRAY_INTEGER = 5;
    public static final byte ARRAY_LONG = 6;
    public static final byte ARRAY_FLOAT = 7;
    public static final byte ARRAY_DOUBLE = 8;
    public static final byte ARRAY_OBJECT = 9;
    public static final byte NUM_ARRAY_TYPES = 10;

    private ArrayUtils() {
    }

    public static boolean arrayEquals(Object __a, Object __b) {
        if (__a == __b) {
            return true;
        }
        if (__a == null != (__b == null)) {
            return false;
        }
        if (__a instanceof Object[]) {
            if (!(__b instanceof Object[])) {
                return false;
            }
            return Arrays.equals((Object[])__a, (Object[])__b);
        }
        if (__a.getClass() != __b.getClass()) {
            return false;
        }
        if (__a instanceof boolean[]) {
            return Arrays.equals((boolean[])__a, (boolean[])__b);
        }
        if (__a instanceof byte[]) {
            return Arrays.equals((byte[])__a, (byte[])__b);
        }
        if (__a instanceof short[]) {
            return Arrays.equals((short[])__a, (short[])__b);
        }
        if (__a instanceof char[]) {
            return Arrays.equals((char[])__a, (char[])__b);
        }
        if (__a instanceof int[]) {
            return Arrays.equals((int[])__a, (int[])__b);
        }
        if (__a instanceof long[]) {
            return Arrays.equals((long[])__a, (long[])__b);
        }
        if (__a instanceof float[]) {
            return Arrays.equals((float[])__a, (float[])__b);
        }
        return Arrays.equals((double[])__a, (double[])__b);
    }

    public static <T> T arrayNew(Class<T> __class, int __type, int __len) throws ClassCastException, IllegalArgumentException, IndexOutOfBoundsException {
        switch (__type) {
            case 1: {
                return __class.cast(new boolean[__len]);
            }
            case 2: {
                return __class.cast(new byte[__len]);
            }
            case 3: {
                return __class.cast(new short[__len]);
            }
            case 4: {
                return __class.cast(new char[__len]);
            }
            case 5: {
                return __class.cast(new int[__len]);
            }
            case 6: {
                return __class.cast(new long[__len]);
            }
            case 7: {
                return __class.cast(new float[__len]);
            }
            case 8: {
                return __class.cast(new double[__len]);
            }
            case 9: {
                return __class.cast(Arrays.copyOf(new Object[0], __len, __class));
            }
        }
        throw new IllegalArgumentException("ZZ5f");
    }

    public static <T> T arrayGet(Class<T> __cast, int __type, Object __a, int __dx) throws ArrayIndexOutOfBoundsException, ClassCastException, IllegalArgumentException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        switch (__type) {
            case 1: {
                return __cast.cast(((boolean[])__a)[__dx]);
            }
            case 2: {
                return __cast.cast(((byte[])__a)[__dx]);
            }
            case 3: {
                return __cast.cast(((short[])__a)[__dx]);
            }
            case 4: {
                return __cast.cast(Character.valueOf(((char[])__a)[__dx]));
            }
            case 5: {
                return __cast.cast(((int[])__a)[__dx]);
            }
            case 6: {
                return __cast.cast(((long[])__a)[__dx]);
            }
            case 7: {
                return __cast.cast(Float.valueOf(((float[])__a)[__dx]));
            }
            case 8: {
                return __cast.cast(((double[])__a)[__dx]);
            }
            case 9: {
                return __cast.cast(((Object[])__a)[__dx]);
            }
        }
        throw new IllegalArgumentException("ZZf7");
    }

    public static void arraySet(Object __a, int __dx, Object __v) throws ArrayIndexOutOfBoundsException, ClassCastException, IllegalArgumentException, NullPointerException {
        ArrayUtils.arraySet(ArrayUtils.arrayType(__a), __a, __dx, __v);
    }

    public static void arraySet(int __type, Object __a, int __dx, Object __v) throws ArrayIndexOutOfBoundsException, ClassCastException, IllegalArgumentException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        switch (__type) {
            case 1: {
                ((boolean[])__a)[__dx] = (Boolean)__v;
                break;
            }
            case 2: {
                ((byte[])__a)[__dx] = ((Number)__v).byteValue();
                break;
            }
            case 3: {
                ((short[])__a)[__dx] = ((Number)__v).shortValue();
                break;
            }
            case 4: {
                ((char[])__a)[__dx] = ((Character)__v).charValue();
                break;
            }
            case 5: {
                ((int[])__a)[__dx] = ((Number)__v).intValue();
                break;
            }
            case 6: {
                ((long[])__a)[__dx] = ((Number)__v).longValue();
                break;
            }
            case 7: {
                ((float[])__a)[__dx] = ((Number)__v).floatValue();
                break;
            }
            case 8: {
                ((double[])__a)[__dx] = ((Number)__v).doubleValue();
                break;
            }
            case 9: {
                ((Object[])__a)[__dx] = __v;
                break;
            }
            default: {
                throw new IllegalArgumentException("ZZ0c");
            }
        }
    }

    public static int arrayType(Object __a) throws IllegalArgumentException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        if (__a instanceof Object[]) {
            return 9;
        }
        if (__a instanceof boolean[]) {
            return 1;
        }
        if (__a instanceof byte[]) {
            return 2;
        }
        if (__a instanceof short[]) {
            return 3;
        }
        if (__a instanceof char[]) {
            return 4;
        }
        if (__a instanceof int[]) {
            return 5;
        }
        if (__a instanceof long[]) {
            return 6;
        }
        if (__a instanceof float[]) {
            return 7;
        }
        if (__a instanceof double[]) {
            return 8;
        }
        throw new IllegalArgumentException("ZZ0d " + __a.getClass().getName());
    }

    public static int[] flatten(IntegerArray ... __arrays) throws NullPointerException {
        if (__arrays == null) {
            throw new NullPointerException("NARG");
        }
        return ArrayUtils.flatten(Arrays.asList(__arrays));
    }

    public static int[] flatten(List<IntegerArray> __arrays) throws NullPointerException {
        if (__arrays == null) {
            throw new NullPointerException("NARG");
        }
        int total = 0;
        for (IntegerArray array : __arrays) {
            int lastTotal = total;
            if ((total += array.size()) >= 0 && total >= lastTotal) continue;
            throw new IllegalStateException("OOPS");
        }
        int[] result = new int[total];
        int n2 = __arrays.size();
        int off = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            IntegerArray source = __arrays.get(i2);
            int sourceLen = source.size();
            if (source instanceof IntegerIntegerArray) {
                ((IntegerIntegerArray)source).copyFrom(0, result, off, sourceLen);
                off += sourceLen;
                continue;
            }
            for (int j2 = 0; j2 < sourceLen; ++j2) {
                result[off++] = source.get(j2);
            }
        }
        return result;
    }

    public static int[] flattenPrimitive(int[] ... __arrays) throws NullPointerException {
        if (__arrays == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __arrays.length;
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return (int[])__arrays[0].clone();
        }
        ArrayList<IntegerArray> wrapped = new ArrayList<IntegerArray>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            wrapped.add(i2, new IntegerIntegerArray(__arrays[i2]));
        }
        return ArrayUtils.flatten(wrapped);
    }

    public static int[] flattenPrimitive(List<int[]> __arrays) throws NullPointerException {
        if (__arrays == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __arrays.size();
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return (int[])__arrays.get(0).clone();
        }
        ArrayList<IntegerArray> wrapped = new ArrayList<IntegerArray>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            wrapped.add(i2, new IntegerIntegerArray(__arrays.get(i2)));
        }
        return ArrayUtils.flatten(wrapped);
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b, int __c) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b, __c});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b, int __c, int __d) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b, __c, __d});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b, int __c, int __d, int __e) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b, __c, __d, __e});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b, int __c, int __d, int __e, int __f) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b, __c, __d, __e, __f});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b, int __c, int __d, int __e, int __f, int __g) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b, __c, __d, __e, __f, __g});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b, int __c, int __d, int __e, int __f, int __g, int __h) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b, __c, __d, __e, __f, __g, __h});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b, int __c, int __d, int __e, int __f, int __g, int __h, int __i) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b, __c, __d, __e, __f, __g, __h, __i});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int __a, int __b, int __c, int __d, int __e, int __f, int __g, int __h, int __i, int __j) throws NegativeArraySizeException, NullPointerException {
        return ArrayUtils.multiANewArray(__type, __skip, new int[]{__a, __b, __c, __d, __e, __f, __g, __h, __i, __j});
    }

    @SquirrelJMEVendorApi
    public static Object multiANewArray(Class<?> __type, int __skip, int[] __dims) throws NegativeArraySizeException, NullPointerException {
        if (__type == null || __dims == null) {
            throw new NullPointerException("NARG");
        }
        String typename = __type.getName();
        int typeDims = 0;
        while (typename.charAt(typeDims) == '[') {
            ++typeDims;
        }
        int dims = __dims.length - __skip;
        if (__skip < 0 || dims <= 0 || typeDims < dims) {
            throw new IllegalArgumentException("ZZ0e");
        }
        int numElem = __dims[__skip];
        Object rv = ObjectShelf.arrayNew(__type, numElem);
        int type = ArrayUtils.arrayType(rv);
        if (dims > 1) {
            Class<?> subtype;
            try {
                subtype = Class.forName(typename.substring(1));
            }
            catch (ClassNotFoundException e2) {
                throw new Error("ZZ0f", e2);
            }
            int nextSkip = __skip + 1;
            for (int i2 = 0; i2 < numElem; ++i2) {
                ArrayUtils.arraySet(type, rv, i2, ArrayUtils.multiANewArray(subtype, nextSkip, __dims));
            }
        }
        return rv;
    }
}

