/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.IntegerList;
import java.util.Arrays;

@SquirrelJMEVendorApi
public final class CharSequenceUtils {
    private CharSequenceUtils() {
    }

    @SquirrelJMEVendorApi
    public static int compare(CharSequence __a, CharSequence __b) throws NullPointerException {
        if (__a == null || __b == null) {
            throw new NullPointerException("NARG");
        }
        int an2 = __a.length();
        int bn2 = __b.length();
        int max = Math.min(an2, bn2);
        for (int i2 = 0; i2 < max; ++i2) {
            int diff = __a.charAt(i2) - __b.charAt(i2);
            if (diff == 0) continue;
            return diff;
        }
        return an2 - bn2;
    }

    @SquirrelJMEVendorApi
    public static int compareIgnoreCase(CharSequence __a, CharSequence __b) throws NullPointerException {
        if (__a == null || __b == null) {
            throw new NullPointerException("NARG");
        }
        int an2 = __a.length();
        int bn2 = __b.length();
        int max = Math.min(an2, bn2);
        for (int i2 = 0; i2 < max; ++i2) {
            char cb2;
            char ca2 = Character.toLowerCase(Character.toUpperCase(__a.charAt(i2)));
            int diff = ca2 - (cb2 = Character.toLowerCase(Character.toUpperCase(__b.charAt(i2))));
            if (diff == 0) continue;
            return diff;
        }
        return an2 - bn2;
    }

    @SquirrelJMEVendorApi
    public static boolean endsWith(CharSequence __what, CharSequence __endsWith) throws NullPointerException {
        if (__what == null || __endsWith == null) {
            throw new NullPointerException("NARG");
        }
        int lenWhat = __what.length();
        int lenEnd = __endsWith.length();
        if (lenEnd == 0) {
            return true;
        }
        if (lenWhat < lenEnd) {
            return false;
        }
        int atWhat = lenWhat - lenEnd;
        int atEnd = 0;
        while (atWhat < lenWhat) {
            if (__what.charAt(atWhat) != __endsWith.charAt(atEnd)) {
                return false;
            }
            ++atWhat;
            ++atEnd;
        }
        return true;
    }

    @SquirrelJMEVendorApi
    public static boolean equals(CharSequence __a, CharSequence __b) throws NullPointerException {
        if (__a == null || __b == null) {
            throw new NullPointerException("NARG");
        }
        if (__a.length() != __b.length()) {
            return false;
        }
        return CharSequenceUtils.compare(__a, __b) == 0;
    }

    @SquirrelJMEVendorApi
    public static CharSequence[] fieldSplit(char __delim, CharSequence __s) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        int[] ind = CharSequenceUtils.multipleIndexOf(__delim, __s);
        int delCount = ind.length;
        int n2 = delCount + 1;
        CharSequence[] rv = new CharSequence[n2];
        int l2 = -1;
        int r2 = 0;
        int i2 = 0;
        while (i2 < n2) {
            rv[i2] = __s.subSequence(l2 >= 0 ? ind[l2] + 1 : 0, r2 < delCount ? ind[r2] : __s.length());
            ++i2;
            ++l2;
            ++r2;
        }
        return rv;
    }

    @SquirrelJMEVendorApi
    public static int firstIndex(char __c, CharSequence __s) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __s.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (__c != __s.charAt(i2)) continue;
            return i2;
        }
        return -1;
    }

    @SquirrelJMEVendorApi
    public static int firstIndex(char[] __c, CharSequence __s) throws NullPointerException {
        if (__c == null || __s == null) {
            throw new NullPointerException("NARG");
        }
        __c = (char[])__c.clone();
        Arrays.sort(__c);
        return CharSequenceUtils.firstIndexSorted(__c, __s);
    }

    @SquirrelJMEVendorApi
    public static int firstIndex(String __c, CharSequence __s) throws NullPointerException {
        if (__c == null || __s == null) {
            throw new NullPointerException("NARG");
        }
        return CharSequenceUtils.firstIndex(__c.toCharArray(), __s);
    }

    @SquirrelJMEVendorApi
    public static int firstIndexSorted(char[] __c, CharSequence __s) throws NullPointerException {
        if (__c == null || __s == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __s.length();
        int y2 = __c.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = __s.charAt(i2);
            if (Arrays.binarySearch(__c, c2) < 0) continue;
            return i2;
        }
        return -1;
    }

    @SquirrelJMEVendorApi
    public static int indexOf(CharSequence __src, CharSequence __lookFor, int __index) {
        if (__src == null || __lookFor == null) {
            throw new NullPointerException("NARG");
        }
        if (__index < 0) {
            __index = 0;
        }
        int srcLen = __src.length();
        int lookLen = __lookFor.length();
        if (lookLen <= 0) {
            return __index;
        }
        if (lookLen > srcLen - __index) {
            return -1;
        }
        int lim = srcLen - lookLen + 1;
        block0: for (int srcAt = __index; srcAt < lim; ++srcAt) {
            int x2 = srcAt;
            for (int b2 = 0; b2 < lookLen; ++b2) {
                if (__src.charAt(x2) != __lookFor.charAt(b2)) continue block0;
                ++x2;
            }
            return srcAt;
        }
        return -1;
    }

    @SquirrelJMEVendorApi
    public static int indexOf(CharSequence __s, int __c, int __i) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __s.length();
        if (__i < 0) {
            __i = 0;
        }
        for (int i2 = __i; i2 < n2; ++i2) {
            if (__c != __s.charAt(i2)) continue;
            return i2;
        }
        return -1;
    }

    @SquirrelJMEVendorApi
    public static int lastIndexOf(String __s, int __c, int __i) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        if (__i < 0) {
            return -1;
        }
        int n2 = __s.length();
        if (__i >= n2) {
            __i = n2 - 1;
        }
        while (__i >= 0) {
            if (__c == __s.charAt(__i)) {
                return __i;
            }
            --__i;
        }
        return -1;
    }

    @SquirrelJMEVendorApi
    public static int[] multipleIndexOf(char __c, CharSequence __s) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        IntegerList list = new IntegerList();
        int n2 = __s.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = __s.charAt(i2);
            if (c2 != __c) continue;
            list.addInteger(i2);
        }
        return list.toIntegerArray();
    }

    @SquirrelJMEVendorApi
    public static boolean startsWith(CharSequence __what, CharSequence __startsWith, int __startIndex) throws IndexOutOfBoundsException, NullPointerException {
        if (__what == null || __startsWith == null) {
            throw new NullPointerException("NARG");
        }
        if (__startIndex < 0) {
            throw new IndexOutOfBoundsException(String.format("ZZ1l %d", __startIndex));
        }
        int lenWhat = __what.length();
        int lenStart = __startsWith.length();
        if (lenStart == 0) {
            return true;
        }
        if (__startIndex + lenStart > lenWhat) {
            return false;
        }
        int atWhat = __startIndex;
        for (int atStart = 0; atStart < lenStart; ++atStart) {
            if (__what.charAt(atWhat) != __startsWith.charAt(atStart)) {
                return false;
            }
            ++atWhat;
        }
        return true;
    }
}

