/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.UnsignedInteger;

@SquirrelJMEVendorApi
public strictfp final class FDMLMath {
    private static final int _SIGN = Integer.MIN_VALUE;
    private static final double _ZERO = 0.0;
    private static final double _ONE = 1.0;
    private static final double _TINY = 1.0E-300;
    private static final double _LN2_HI = 0.6931471803691238;
    private static final double _LN2_LO = 1.9082149292705877E-10;
    private static final double _TWO54 = 1.8014398509481984E16;
    private static final double _LG1 = 0.6666666666666735;
    private static final double _LG2 = 0.3999999999940942;
    private static final double _LG3 = 0.2857142874366239;
    private static final double _LG4 = 0.22222198432149784;
    private static final double _LG5 = 0.1818357216161805;
    private static final double _LG6 = 0.15313837699209373;
    private static final double _LG7 = 0.14798198605116586;

    private FDMLMath() {
    }

    @SquirrelJMEVendorApi
    public static double log(double __v) {
        int hx = FDMLMath.__hi(__v);
        int uulx = FDMLMath.__lo(__v);
        int k2 = 0;
        if (hx < 0x100000) {
            if ((hx & Integer.MAX_VALUE | uulx) == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (hx < 0) {
                return Double.NaN;
            }
            k2 -= 54;
            hx = FDMLMath.__hi(__v *= 1.8014398509481984E16);
        }
        if (hx >= 0x7FF00000) {
            return __v + __v;
        }
        k2 += (hx >> 20) - 1023;
        int i2 = (hx &= 0xFFFFF) + 614244 & 0x100000;
        __v = FDMLMath.__compose(hx | i2 ^ 0x3FF00000, FDMLMath.__lo(__v));
        k2 += i2 >> 20;
        double f2 = __v - 1.0;
        if ((0xFFFFF & 2 + hx) < 3) {
            if (f2 == 0.0) {
                if (k2 == 0) {
                    return 0.0;
                }
                double dk2 = k2;
                return dk2 * 0.6931471803691238 + dk2 * 1.9082149292705877E-10;
            }
            double r2 = f2 * f2 * (0.5 - 0.3333333333333333 * f2);
            if (k2 == 0) {
                return f2 - r2;
            }
            double dk3 = k2;
            return dk3 * 0.6931471803691238 - (r2 - dk3 * 1.9082149292705877E-10 - f2);
        }
        double s2 = f2 / (2.0 + f2);
        double dk4 = k2;
        double z2 = s2 * s2;
        i2 = hx - 398458;
        double w2 = z2 * z2;
        int j2 = 440401 - hx;
        double t1 = w2 * (0.3999999999940942 + w2 * (0.22222198432149784 + w2 * 0.15313837699209373));
        double t2 = z2 * (0.6666666666666735 + w2 * (0.2857142874366239 + w2 * (0.1818357216161805 + w2 * 0.14798198605116586)));
        double r3 = t2 + t1;
        if ((i2 |= j2) > 0) {
            double hfsq = 0.5 * f2 * f2;
            if (k2 == 0) {
                return f2 - (hfsq - s2 * (hfsq + r3));
            }
            return dk4 * 0.6931471803691238 - (hfsq - (s2 * (hfsq + r3) + dk4 * 1.9082149292705877E-10) - f2);
        }
        if (k2 == 0) {
            return f2 - s2 * (f2 - r3);
        }
        return dk4 * 0.6931471803691238 - (s2 * (f2 - r3) - dk4 * 1.9082149292705877E-10 - f2);
    }

    @SquirrelJMEVendorApi
    public static double sqrt(double __v) {
        double z2;
        int t2;
        int uur;
        int m2;
        int ix0 = FDMLMath.__hi(__v);
        int uuix1 = FDMLMath.__lo(__v);
        if ((ix0 & 0x7FF00000) == 0x7FF00000) {
            return __v * __v + __v;
        }
        if (ix0 <= 0) {
            if ((ix0 & Integer.MAX_VALUE | uuix1) == 0) {
                return __v;
            }
            if (ix0 < 0) {
                return (__v - __v) / (__v - __v);
            }
        }
        if ((m2 = ix0 >> 20) == 0) {
            while (ix0 == 0) {
                m2 -= 21;
                ix0 |= uuix1 >>> 11;
                uuix1 <<= 21;
            }
            int i2 = 0;
            while ((ix0 & 0x100000) == 0) {
                ix0 <<= 1;
                ++i2;
            }
            m2 -= i2 - 1;
            ix0 |= uuix1 >>> 32 - i2;
            uuix1 <<= i2;
        }
        ix0 = ix0 & 0xFFFFF | 0x100000;
        if (((m2 -= 1023) & 1) != 0) {
            ix0 += ix0 + ((uuix1 & Integer.MIN_VALUE) >>> 31);
            uuix1 += uuix1;
        }
        m2 >>= 1;
        ix0 += ix0 + ((uuix1 & Integer.MIN_VALUE) >>> 31);
        uuix1 += uuix1;
        int uus1 = 0;
        int s0 = 0;
        int uuq1 = 0;
        int q2 = 0;
        for (uur = 0x200000; uur != 0; uur >>>= 1) {
            t2 = s0 + uur;
            if (t2 <= ix0) {
                s0 = t2 + uur;
                ix0 -= t2;
                q2 += uur;
            }
            ix0 += ix0 + ((uuix1 & Integer.MIN_VALUE) >>> 31);
            uuix1 += uuix1;
        }
        for (uur = Integer.MIN_VALUE; uur != 0; uur >>>= 1) {
            int uut1 = uus1 + uur;
            t2 = s0;
            if (t2 < ix0 || t2 == ix0 && UnsignedInteger.compareSignedUnsigned(uut1, uuix1) <= 0) {
                uus1 = uut1 + uur;
                if ((uut1 & Integer.MIN_VALUE) == Integer.MIN_VALUE && (uus1 & Integer.MIN_VALUE) == 0) {
                    ++s0;
                }
                ix0 -= t2;
                if (UnsignedInteger.compareUnsigned(uuix1, uut1) < 0) {
                    --ix0;
                }
                uuix1 -= uut1;
                uuq1 += uur;
            }
            ix0 += ix0 + ((uuix1 & Integer.MIN_VALUE) >>> 31);
            uuix1 += uuix1;
        }
        if ((ix0 | uuix1) != 0 && (z2 = 1.0) >= 1.0) {
            z2 = 1.0;
            if (uuq1 == -1) {
                uuq1 = 0;
                ++q2;
            } else if (z2 > 1.0) {
                if (uuq1 == -2) {
                    ++q2;
                }
                uuq1 += 2;
            } else {
                uuq1 += uuq1 & 1;
            }
        }
        ix0 = (q2 >> 1) + 1071644672;
        uuix1 = uuq1 >>> 1;
        if ((q2 & 1) == 1) {
            uuix1 |= Integer.MIN_VALUE;
        }
        return FDMLMath.__compose(ix0 += m2 << 20, uuix1);
    }

    private static double __compose(int __hi, int __lo) {
        return Double.longBitsToDouble(((long)__hi & 0xFFFFFFFFL) << 32 | (long)__lo & 0xFFFFFFFFL);
    }

    private static int __hi(double __v) {
        return (int)(Double.doubleToRawLongBits(__v) >>> 32);
    }

    private static int __lo(double __v) {
        return (int)Double.doubleToRawLongBits(__v);
    }
}

