/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

@SquirrelJMEVendorApi
public class FloatArrayList
extends AbstractList<Float>
implements RandomAccess {
    @SquirrelJMEVendorApi
    protected final float[] array;
    @SquirrelJMEVendorApi
    protected final int offset;
    @SquirrelJMEVendorApi
    protected final int size;

    @SquirrelJMEVendorApi
    public FloatArrayList(float[] __a) throws NullPointerException {
        this(__a, 0, __a.length);
    }

    @SquirrelJMEVendorApi
    public FloatArrayList(float[] __a, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __a.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        this.array = __a;
        this.offset = __o;
        this.size = __l;
    }

    @Override
    public Float get(int __i) {
        if (__i < 0 || __i >= this.size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        return Float.valueOf(this.array[this.offset + __i]);
    }

    @Override
    @SquirrelJMEVendorApi
    public float set(int __i, float __v) throws IndexOutOfBoundsException {
        return this.set(__i, Float.valueOf(__v)).floatValue();
    }

    @Override
    public Float set(int __i, Float __v) throws IndexOutOfBoundsException, NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        if (__i < 0 || __i >= this.size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int truedx = this.offset + __i;
        float[] array = this.array;
        float rv = array[truedx];
        array[truedx] = __v.floatValue();
        return Float.valueOf(rv);
    }

    @Override
    public int size() {
        return this.size;
    }

    @SquirrelJMEVendorApi
    public static List<Float> asList(float ... __array) {
        return new FloatArrayList(__array);
    }
}

